/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.io.GardenFormatV1;
import org.sourceforge.kga.io.GardenFormatXmlV1;
import org.sourceforge.kga.io.GardenFormatXmlV2;
import org.sourceforge.kga.io.InvalidFormatException;

public class SerializableGarden {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    static GardenFormatV1 v1 = new GardenFormatV1();
    static GardenFormatXmlV1 xmlV1 = new GardenFormatXmlV1();
    static GardenFormatXmlV2 xmlV2 = new GardenFormatXmlV2();

    public static void load(Garden garden, InputStream inputStream) throws IOException, InvalidFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while (inputStream.available() > 0) {
            int n = inputStream.read(byArray, 0, 65536);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            xmlV2.load(garden, byteArrayInputStream);
            return;
        }
        catch (InvalidFormatException invalidFormatException) {
            try {
                byteArrayInputStream.reset();
                xmlV1.load(garden, byteArrayInputStream);
                return;
            }
            catch (InvalidFormatException invalidFormatException2) {
                byteArrayInputStream.reset();
                v1.load(garden, byteArrayInputStream);
                return;
            }
        }
    }

    public static void saveToFile(Garden garden, File file) throws FileNotFoundException, IOException {
        log.info("Saving to " + file.getAbsolutePath());
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        xmlV2.save(garden, dataOutputStream);
        dataOutputStream.close();
    }
}

