/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.plant;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.GardenObserver;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.Rectangle;
import org.sourceforge.kga.TagList;
import org.sourceforge.kga.TagListener;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.translation.Translation;

public class TagInGarden
extends Tag
implements GardenObserver {
    Garden garden = null;
    static TagInGarden instance = new TagInGarden();

    private TagInGarden() {
        super("", null);
    }

    @Override
    public String getName() {
        return Translation.getPreferred().species_in_garden();
    }

    public void setGarden(Garden garden) {
        if (this.garden != null) {
            this.garden.removeObserver(this);
        }
        this.garden = garden;
        this.garden.addObserver(this);
    }

    @Override
    public Set<Plant> getSpecies() {
        HashSet<Plant> hashSet = new HashSet<Plant>();
        if (this.garden == null) {
            return hashSet;
        }
        for (Map.Entry<Integer, HashMap<Point, List<Plant>>> entry : this.garden.getAllSquares().entrySet()) {
            for (Map.Entry<Point, List<Plant>> entry2 : entry.getValue().entrySet()) {
                hashSet.addAll((Collection<Plant>)entry2.getValue());
            }
        }
        return hashSet;
    }

    @Override
    public void yearDeleted() {
        for (TagListener tagListener : TagList.getInstance().getListeners()) {
            tagListener.tagChanged(this);
        }
    }

    @Override
    public void hintsChanged(int n, Point point) {
    }

    @Override
    public void plantsChanged(int n, Point point) {
        for (TagListener tagListener : TagList.getInstance().getListeners()) {
            tagListener.tagChanged(this);
        }
    }

    @Override
    public void boundsChanged(Rectangle rectangle) {
    }

    public static TagInGarden getInstance() {
        return instance;
    }
}

