/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.ArrayList;
import java.util.List;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.NutritionalNeeds;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class RotationNutritionalNeeds
extends Rule {
    private boolean goodRotation(NutritionalNeeds.Type type, NutritionalNeeds.Type type2) {
        return type2 == NutritionalNeeds.Type.HIGH && type == NutritionalNeeds.Type.LOW || type2 == NutritionalNeeds.Type.LOW && type == NutritionalNeeds.Type.SOIL_IMPROVER || type2 == NutritionalNeeds.Type.SOIL_IMPROVER && type == NutritionalNeeds.Type.HIGH;
    }

    private boolean badRotation(NutritionalNeeds.Type type, NutritionalNeeds.Type type2) {
        return type2 == NutritionalNeeds.Type.HIGH && type == NutritionalNeeds.Type.HIGH || type2 == NutritionalNeeds.Type.LOW && type == NutritionalNeeds.Type.HIGH || type2 == NutritionalNeeds.Type.LOW && type == NutritionalNeeds.Type.LOW;
    }

    @Override
    public void getHints(HintList hintList) {
        Point point;
        int n;
        Garden garden = hintList.getGarden();
        List<Plant> list = garden.getPlants(n = hintList.getYear(), point = hintList.getGrid());
        if (list == null) {
            return;
        }
        List<Plant> list2 = garden.getPlants(n - 1, point);
        if (list2 == null) {
            return;
        }
        NutritionalNeeds.Type type = NutritionalNeeds.Type.SOIL_IMPROVER;
        ArrayList<Plant> arrayList = new ArrayList<Plant>();
        for (Plant plant : list2) {
            if (plant.getNutritionalNeeds() == null) continue;
            if (plant.getNutritionalNeeds().type.ordinal() > type.ordinal()) {
                type = plant.getNutritionalNeeds().type;
                arrayList.clear();
            }
            if (plant.getNutritionalNeeds().type != type) continue;
            arrayList.add(plant);
        }
        list2 = arrayList;
        for (Plant plant : list) {
            if (plant.isItem() || plant.getNutritionalNeeds() == null) continue;
            for (Plant plant2 : list2) {
                Hint.Value value;
                if (plant2 != plant && plant2.getFamily() != plant.getFamily() && hintList.addRotationHint(value = this.badRotation(plant.getNutritionalNeeds().type, plant2.getNutritionalNeeds().type) ? Hint.Value.BAD : (this.goodRotation(plant.getNutritionalNeeds().type, plant2.getNutritionalNeeds().type) ? Hint.Value.GOOD : Hint.Value.TIP), plant, plant2, n - 1, this)) break;
            }
        }
    }

    @Override
    public String getDescription(Hint hint) {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hint.getValue() == Hint.Value.GOOD ? translation.rotation_good() : translation.rotation_bad());
        stringBuilder.append(" ");
        stringBuilder.append(hint.getCurrentPlant().getNutritionalNeeds().translate());
        stringBuilder.append(" ");
        stringBuilder.append(translation.rotation_after());
        stringBuilder.append(" ");
        stringBuilder.append(hint.getNeighborPlant().getNutritionalNeeds().translate());
        return stringBuilder.toString();
    }

    @Override
    public void addReferencesToList(Hint hint, ReferenceList referenceList) {
        referenceList.add(hint.getNeighborPlant().getNutritionalNeeds().references);
        referenceList.add(hint.getCurrentPlant().getNutritionalNeeds().references);
    }
}

