/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.translation;

import java.text.Normalizer;
import java.util.TreeSet;

public class Iso639_1 {
    private static final Language[] languages = new Language[]{new Language("en", "English"), new Language("aa", "Afaraf"), new Language("ab", "\u0410\u04a7\u0441\u0443\u0430"), new Language("ae", "Avesta"), new Language("af", "Afrikaans"), new Language("ak", "Akan"), new Language("an", "Aragon\u00e9s"), new Language("ar", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629"), new Language("as", "\u0985\u09b8\u09ae\u09c0\u09af\u09bc\u09be"), new Language("av", "\u0410\u0432\u0430\u0440 \u043c\u0430\u0446\u04c0"), new Language("ay", "Aymar aru"), new Language("az", "Az\u0259rbaycan dili"), new Language("ba", "\u0411\u0430\u0448\u04a1\u043e\u0440\u0442 \u0442\u0435\u043b\u0435"), new Language("be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f"), new Language("bg", "\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u0435\u0437\u0438\u043a"), new Language("bh", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940"), new Language("bi", "Bislama"), new Language("bm", "Bamanankan"), new Language("bn", "\u09ac\u09be\u0982\u09b2\u09be"), new Language("bo", "\u0f56\u0f7c\u0f51\u0f0b\u0f61\u0f72\u0f42"), new Language("br", "Brezhoneg"), new Language("bs", "Bosanski jezik"), new Language("ca", "Catal\u00e0"), new Language("ce", "\u043d\u043e\u0445\u0447\u0438\u0439\u043d \u043c\u043e\u0442\u0442"), new Language("ch", "Chamoru"), new Language("co", "Corsu"), new Language("cs", "\u010cesky"), new Language("cu", "\u0469\u0437\u044b\u043a\u044a \u0441\u043b\u043e\u0432\u0463\u043d\u044c\u0441\u043a\u044a"), new Language("cv", "\u0447\u04d1\u0432\u0430\u0448 \u0447\u04d7\u043b\u0445\u0438"), new Language("cy", "Cymraeg"), new Language("da", "Dansk"), new Language("de", "Deutsch"), new Language("dz", "\u0f62\u0fab\u0f7c\u0f44\u0f0b\u0f41"), new Language("ee", "E\u028begbe"), new Language("el", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"), new Language("eo", "Esperanto"), new Language("es", "Espa\u00f1ol"), new Language("et", "Eesti"), new Language("eu", "Euskara"), new Language("fa", "\u0641\u0627\u0631\u0633\u06cc"), new Language("ff", "Fulfulde"), new Language("fi", "Suomi"), new Language("fj", "Vosa Vakaviti"), new Language("fo", "F\u00f8royskt"), new Language("fr", "Fran\u00e7ais"), new Language("fy", "Frysk"), new Language("ga", "Gaeilge"), new Language("gd", "G\u00e0idhlig"), new Language("gl", "Galego"), new Language("gn", "Ava\u00f1e'\u1ebd"), new Language("gu", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0"), new Language("gv", "Gaelg"), new Language("ha", "Hausa"), new Language("he", "\u05e2\u05d1\u05e8\u05d9\u05ea"), new Language("hi", "\u0939\u093f\u0928\u094d\u0926\u0940"), new Language("ho", "Hiri Motu"), new Language("hr", "Hrvatski"), new Language("ht", "Krey\u00f2l ayisyen"), new Language("hu", "Magyar"), new Language("hy", "\u0540\u0561\u0575\u0565\u0580\u0565\u0576"), new Language("hz", "Otjiherero"), new Language("ia", "Interlingua"), new Language("id", "Bahasa Indonesia"), new Language("ie", "Interlingue"), new Language("ig", "Igbo"), new Language("ik", "I\u00f1upiaq"), new Language("io", "Ido"), new Language("is", "\u00cdslenska"), new Language("it", "Italiano"), new Language("ja", "\u65e5\u672c\u8a9e"), new Language("jv", "Basa Jawa"), new Language("ka", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8"), new Language("kg", "KiKongo"), new Language("ki", "G\u0129k\u0169y\u0169"), new Language("kj", "Kuanyama"), new Language("kk", "\u049a\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456"), new Language("kl", "Kalaallisut"), new Language("km", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a"), new Language("kn", "\u0c95\u0ca8\u0ccd\u0ca8\u0ca1"), new Language("ko", "\ud55c\uad6d\uc5b4"), new Language("kr", "Kanuri"), new Language("ks", "\u0915\u0936\u094d\u092e\u0940\u0930\u0940"), new Language("ku", "Kurd\u00ee"), new Language("kv", "\u041a\u043e\u043c\u0438 \u043a\u044b\u0432"), new Language("kw", "Kernewek"), new Language("ky", "\u041a\u044b\u0440\u0433\u044b\u0437 \u0442\u0438\u043b\u0438"), new Language("la", "Latine"), new Language("lb", "L\u00ebtzebuergesch"), new Language("lg", "Luganda"), new Language("li", "Limburgs"), new Language("ln", "Ling\u00e1la"), new Language("lo", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7"), new Language("lt", "Lietuvi\u0173 kalba"), new Language("lv", "Latvie\u0161u valoda"), new Language("mg", "Malagasy fiteny"), new Language("mh", "Kajin M\u0327aje\u013c"), new Language("mi", "Te reo M\u0101ori"), new Language("mk", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 \u0458\u0430\u0437\u0438\u043a"), new Language("ml", "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02"), new Language("mn", "\u041c\u043e\u043d\u0433\u043e\u043b"), new Language("mr", "\u092e\u0930\u093e\u0920\u0940"), new Language("ms", "Bahasa Melayu"), new Language("mt", "Malti"), new Language("na", "Ekakair\u0169 Naoero"), new Language("nb", "Norsk bokm\u00e5l"), new Language("nd", "IsiNdebele"), new Language("ne", "\u0928\u0947\u092a\u093e\u0932\u0940"), new Language("ng", "Owambo"), new Language("nl", "Nederlands"), new Language("nn", "Norsk nynorsk"), new Language("no", "Norsk"), new Language("nr", "IsiNdebele"), new Language("nv", "Din\u00e9 bizaad"), new Language("ny", "ChiChe\u0175a"), new Language("oc", "Occitan"), new Language("om", "Afaan Oromoo"), new Language("or", "\u0b13\u0b21\u0b3c\u0b3f\u0b06"), new Language("os", "\u0418\u0440\u043e\u043d \u00e6\u0432\u0437\u0430\u0433"), new Language("pa", "\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40"), new Language("pi", "\u092a\u093e\u0934\u093f"), new Language("pl", "Polski"), new Language("ps", "\u067e\u069a\u062a\u0648"), new Language("pt", "Portugu\u00eas"), new Language("qu", "Runa Simi"), new Language("rm", "Rumantsch grischun"), new Language("rn", "KiRundi"), new Language("ro", "Rom\u00e2n\u0103"), new Language("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a"), new Language("rw", "Ikinyarwanda"), new Language("sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924\u092e\u094d"), new Language("sc", "Sardu"), new Language("sd", "\u0938\u093f\u0928\u094d\u0927\u0940"), new Language("se", "Davvis\u00e1megiella"), new Language("sg", "Y\u00e2ng\u00e2 t\u00ee s\u00e4ng\u00f6"), new Language("sk", "Sloven\u010dina"), new Language("sl", "Sloven\u0161\u010dina"), new Language("sm", "Gagana fa'a Samoa"), new Language("sn", "ChiShona"), new Language("so", "Soomaaliga"), new Language("sq", "Shqip"), new Language("sr", "\u0421\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a"), new Language("ss", "SiSwati"), new Language("st", "Sesotho"), new Language("su", "Basa Sunda"), new Language("sv", "Svenska"), new Language("sw", "Kiswahili"), new Language("ta", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd"), new Language("te", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41"), new Language("tg", "\u0422\u043e\u04b7\u0438\u043a\u04e3"), new Language("th", "\u0e44\u0e17\u0e22"), new Language("tk", "T\u00fcrkmen"), new Language("tl", "Wikang Tagalog"), new Language("tn", "Setswana"), new Language("to", "Faka Tonga"), new Language("tr", "T\u00fcrk\u00e7e"), new Language("ts", "Xitsonga"), new Language("tt", "\u0422\u0430\u0442\u0430\u0440\u0447\u0430"), new Language("tw", "Twi"), new Language("ty", "Reo M\u0101`ohi"), new Language("ug", "Uy\u01a3urq\u0259"), new Language("uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"), new Language("ur", "\u0627\u0631\u062f\u0648"), new Language("uz", "O'zbek"), new Language("ve", "Tshiven\u1e13a"), new Language("vi", "Ti\u1ebfng Vi\u1ec7t"), new Language("vo", "Volap\u00fck"), new Language("wa", "Walon"), new Language("wo", "Wollof"), new Language("xh", "IsiXhosa"), new Language("yi", "\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9"), new Language("yo", "Yor\u00f9b\u00e1"), new Language("za", "Sa\u026f cue\u014b\u0185"), new Language("zh", "\u4e2d\u6587"), new Language("zu", "IsiZulu")};
    static Language[] languagesSet = null;

    public static String getLanguageName(String string) {
        Language language = Iso639_1.getLanguage(string);
        if (language == null) {
            return null;
        }
        return language.name;
    }

    public static Language getLanguage(String string) {
        if (string.equals("en")) {
            return languages[0];
        }
        int n = 1;
        int n2 = languages.length;
        while (true) {
            int n3 = n + (n2 - n) / 2;
            Language language = languages[n3];
            int n4 = string.compareTo(language.code);
            if (n4 == 0) {
                return language;
            }
            if (n3 == n) {
                return null;
            }
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
    }

    public static Language[] getLanguages() {
        if (languagesSet == null) {
            TreeSet<Language> treeSet = new TreeSet<Language>();
            for (Language language : languages) {
                treeSet.add(language);
            }
            languagesSet = new Language[treeSet.size()];
            treeSet.toArray(languagesSet);
        }
        return languagesSet;
    }

    public static String simplifyString(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").toLowerCase();
    }

    public static boolean containsText(String string, String string2) {
        return Iso639_1.simplifyString(string).contains(Iso639_1.simplifyString(string2));
    }

    public static class Language
    implements Comparable<Language> {
        public String code;
        public String name;

        public Language(String string, String string2) {
            this.code = string;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Language language) {
            if (this.code.equals("en")) {
                return -1;
            }
            if (language.code.equals("en")) {
                return 1;
            }
            return this.code.compareTo(language.code);
        }
    }
}

