<?php
header("content-type: text/css");
include realpath(dirname(__file__).'/../../config.php');
$col1='#1976D2'; // dark primary color
$col2='#2196F3'; // primary color
$col3='#BBDEFB'; // light primary color
$col4='#FFFFFF'; // text / icons
$col5='#8BC34A'; // accent color
$col6='#212121'; // primary text
$col7='#727272'; // secondary text
$col8='#B6B6B6'; // devider color
$col9='#5a5b5d'; // devider color
$col10='#F44336'; // devider color
?>

@font-face {
	font-family: 'Open Sans';
	font-style: normal;
	font-weight: 400;
	src: local('Open Sans'), local('OpenSans'), url(/themes/<?php echo $theme; ?>/OpenSans.woff2) format('woff2');
}

body, p {
	padding: 0;
	margin: 0;
	font-family: 'Open Sans', Arial, serif;
}

.iconround {
	padding: 4px;
	background: <?php echo $col5; ?>;
	border-radius: 10px;
	display: inline-block;
}

.internalbox {
	margin: 5px;
	overflow: hidden;
	position: relative;
}

.coverlink {
	display: block;
	width: 50px;
	height: 50px;
	text-decoration: none;
}
.coverlink:hover {
	text-decoration: none;
}

.seldiv {
	background: <?php echo $col3; ?>;
	padding: 10px;
	overflow: hidden;
}

.forprefixedactions {
	height: 50px;
}
.prefixedactions {
	text-align: right;
	width: 100%;
	margin: 0 auto;
	padding: 10px 5px;
}
.fixedactions {
	top: 0;
	position: fixed;
	z-index: 1000;
	background: rgba(255,255,255,0.7); 
	box-shadow: 0 0 5px rgba(0,0,0,0.5);
}

.coverblock, .coverblock:link, .coverblock:visited, .coverblock:active {
	display: block;
	width: 100%;
	height: 100px;
	box-shadow: 1px 1px 3px rgba(0,0,0,0.4);
	text-decoration: none;
	color: white;
	position: relative;
}
.coverblock:hover {
	text-decoration: none;
	box-shadow: 1px 1px 5px rgba(0,0,0,0.7);
}

.reptitle {
	color: <?php echo $col6; ?>;
	font-size: 16px;
}
.repauthor {
	color: <?php echo $col7; ?>;
}
.replink {
	color: <?php echo $col2; ?>;
	text-decoration: none;
}
.replink:hover {
	color: <?php echo $col2; ?>;
	text-decoration: underline;	
}
.replinkrelation {
	color: <?php echo $col7; ?>;
	text-decoration: none;
}
.replinkrelation:hover {
	color: <?php echo $col7; ?>;
	text-decoration: underline;	
}

.typeicon {
	font-size: 20px;
	margin-left: 10px;
	color: <?php echo $col8; ?>;
}
.typeicon:hover {
	color: <?php echo $col2; ?>;
}

.typeiconselected {
	color: <?php echo $col2; ?>;
}

.catalogfield {
	font-weight: bold;
	margin: 20px 0 5px 0;
	color: <?php echo $col7; ?>;
}

.explo_mid {
	display: inline-block;
	width: 16px;
	height: 24px;
	background: url('/themes/<?php echo $theme; ?>/explo_mid.png') left center;
	vertical-align: middle;
}

.explo_end {
	display: inline-block;
	width: 16px;
	height: 24px;
	background: url('/themes/<?php echo $theme; ?>/explo_end.png') left center;
	vertical-align: middle;
}

label {
	font-weight: normal;
}

a {
	color: <?php echo $col6; ?>;
}
a:hover {
	color: <?php echo $col6; ?>;
}

.select2-selection__arrow {
	background: <?php echo $col5; ?>;
}
.select2-container--default {
	border: 0;
}
.select2-selection--single {
	border: 0;
}

.linklangs, .linklangs:link, .linklangs:visited, .linklangs:active {
	margin-left: 15px;
}
.linklangs:hover {
	color: <?php echo $col5; ?>;
}

.button, .button:link, .button:visited, .button:active {
	background: <?php echo $col5; ?>;
	color: <?php echo $col4; ?>;
	text-decoration: none;
	padding: 1px 5px;
	border-radius: 1px;
}
.button:hover {
	background: <?php echo $col1; ?>;
	color: <?php echo $col4; ?>;
	text-decoration: none;
}

.digrarytable td {
	border: 0 !important;
	padding: 0 !important;
}

.topheaderdiv {
	background: <?php echo $col1; ?>;
	font-size: 12px;
}
.headerdiv {
	background: <?php echo $col2; ?>;
}

.controlpanel {
	background: <?php echo $col7; ?>;
}
.controlpanel p {
	color: <?php echo $col4; ?>;
}
.controlpanel a {
	color: <?php echo $col4; ?>;
}

.noname {
	color: <?php echo $col10; ?>;
}

.langdiv {
	border: 1px solid silver;
	margin: 20px auto;
	padding: 10px;
}

a.backlink, a.backlink:active {
	background: <?php echo $col3; ?>;
	color: white;
	font-size: 20px;
	display: block;
	width: 100%;
	text-align: center;
	cursor: pointer;
	padding: 10px 0;
	text-decoration: none;
}
a.backlink:hover {
	background: <?php echo $col2; ?>;
	color: white;
	text-decoration: none;
}

.logoup {
	color: <?php echo $col3; ?>;
	font-size: 13px;
	line-height: 100%;
	margin: 5px 0;
}

a.logo {
	font-size: 36px;
	text-transform: uppercase;
	color: white;
	text-decoration: none;
}

.divinput {
	border: 0;
	box-shadow: 1px 1px 1px rgba(0,0,0,0.2);
}
.searchinput {
	border: 0;
	border-radius: 1px 0 0 1px;
}
.searchinput:focus {
	box-shadow: none;
}
.searchbutton {
	border-radius: 0 1px 1px 0;
	font-size: 17px;
	padding: 5px 10px;
}
.searchbutton:hover {
}


.tabbox {
	display: inline-block;
	background: <?php echo $col7; ?>;
	color: <?php echo $col4; ?>;
	padding: 5px 10px;
	font-weight: bold;
}
a.tab, a.tab:link, a.tab:active, a.tab:visited {
	text-decoration: none;
}
a.tab:hover {
	text-decoration: none;
	background: <?php echo $col6; ?>;
	color: white;
}
a.tabactive, a.tabactive:link, a.tabactive:active, a.tabactive:visited {
	text-decoration: none;
	color: white;
	background: <?php echo $col5; ?>;
}
a.tabactive:hover {
	text-decoration: none;
	color: white;
	background: <?php echo $col6; ?>;
}


a.itembox {
	background: white;
	display: inline-block;
	margin: 10px;
	text-decoration: none;
	width: 180px;
	height: 350px;
	color: <?php echo $col6; ?>;
	box-shadow: 0 0 5px rgba(0,0,0,0.2);
	overflow: hidden;
}
a.itembox:hover {
	box-shadow: 0 0 5px 5px rgba(0,0,0,0.2);
	text-decoration: none;
	color: black;
}

.btn-primary {
	background: <?php echo $col5; ?>;
	border: <?php echo $col5; ?>;
	border-radius: 1px;
}
.btn-primary:hover {
	background: <?php echo $col6; ?>;
	border: <?php echo $col6; ?>;
}

.btn-action {
	display: inline-block;
	color: <?php echo $col4; ?>;
	text-decoration: none;
	text-shadow: 1px 1px 1px rgba(0,0,0,0.3);
	padding: 1px 4px;
	background: <?php echo $col5; ?>;
	border: 0;
	cursor: pointer;
	border-radius: 2px;
}
.btn-action:hover {
	color: <?php echo $col4; ?>;
    box-shadow: 0 0 5px rgba(0,0,0,0.5);
	background: #2c3139;
	cursor: pointer;
	text-decoration: none;
}
.btn-action-disable {
	display: inline-block;
	color: rgba(255,255,255,0.5);
	text-decoration: none;
	text-shadow: 1px 1px 1px rgba(0,0,0,0.5);
	padding: 1px 4px;
	background: <?php echo $col5; ?>;
	border: 0;
	cursor: normal;
	border-radius: 2px;
	text-shadow: none;
}

.invisibleitem {
	background: #ffe0e2 !important;
}


.pagination > li > a, .pagination > li > span {
    color: <?php echo $col6; ?>;
}
.pagination > .active > a, .pagination > .active > a:focus, .pagination > .active > a:hover, .pagination > .active > span, .pagination > .active > span:focus, .pagination > .active > span:hover {
    background-color: <?php echo $col5; ?>;
    border-color: <?php echo $col5; ?>;
}

.breadcrumb {
	font-size: 13px;
	color: <?php echo $col7; ?>;
	margin-bottom: 10px;
	background: none !important;
	padding: 0;
	margin: 0;
}
.breadcrumb a, .breadcrumb a:link, .breadcrumb a:visited, .breadcrumb a:active {
	color: <?php echo $col7; ?>;
	text-decoration: none;
}
.breadcrumb a:hover {
	color: <?php echo $col2; ?>;
	text-decoration: none;
}

.topmenu, .topmenu:link, .topmenu:visited, .topmenu:active {
	margin-right: 30px;
	text-decoration: none;
	font-size: 16px;
	color: white;
	cursor: pointer;
	padding: 5px 0;
	display: inline-block;
	border-bottom: 2px solid transparent;
}
.topmenu:hover {
	text-decoration: none;
	border-bottom: 2px solid white;
	color: white;
}
.topmenuselected {
	border-bottom: 2px solid white !important;
}

.dropmenu2, .dropmenu2 ul { margin: 0; padding: 0; list-style-type: none; position: relative; line-height: 2.5em;}
.dropmenu2 a { text-decoration: none;}
.dropmenu2 > li { margin-right: 30px; }
.dropmenu2 > li:first { margin-left: 0px !important;}
.dropmenu2 > li > a { line-height: 20px; padding: 5px 0; margin: 0; width: 100%; text-decoration: none; font-size: 16px; color: white; cursor: pointer;}
.dropmenu2 > li > a:hover { border-bottom: 2px solid white; }
.dropmenu2 > li > a.menuselected { border-bottom: 2px solid white; }
div.box { position: absolute; background-color: #3b6196; left: 0; top: 0; box-shadow: 2px 2px 2px rgba(0,0,0,0.2);}
li.pull-down { padding-right: 6px;}
li.pull-down > a { background-image: url('darrow.png'); background-position: 96% 50%; background-repeat: no-repeat; padding-right: 20px;}
li.right-menu > a { background-image: url('rarrow.png'); background-position: 97% 45%; background-repeat: no-repeat;}
.dropmenu2 a.selected { background-color: #3b6196;}
.dropmenu2 li { float: left; position: relative;}
.dropmenu2 ul { position: absolute; display: none; width: 200px; /* top: 2.5em; padding-right: 10px;*/ background-color: #3b6196; box-shadow: 2px 2px 2px rgba(0,0,0,0.2); opacity: 0.9;}
.dropmenu2 li ul a { width: 200px; display: block; height: auto; float: left; color: <?php echo $col4; ?>; padding: 0 10px; text-align: left;}
.dropmenu2 li ul li { padding: 0; margin: 0;}
.dropmenu2 ul ul { top: auto;}
.dropmenu2 li ul ul { left: 198px; /*margin: 0px 0 0 10px;*/}
.menu-item-selected > a { background-color: #dae4f1;}
.menu-item-selected > a:hover { color: black !important;}