/*
 * Decompiled with CFR 0.152.
 */
package org.verus.ngl.indexing;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.verus.ngl.util.DBConnector;
import org.verus.ngl.util.SystemFilesLoader;

public class DiscussionIndexer {
    public static void main(String[] args) {
        DiscussionIndexer bsic = new DiscussionIndexer();
        bsic.deleteData();
        bsic.indexingData();
    }

    public void deleteData() {
        try {
            System.out.println("-----------Deleting User profile index data--------");
            Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
            String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_DISCUSSION_DATA", "http://localhost:8080/apache-solr-discussion");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
            server.deleteByQuery("*:*");
            server.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void indexingData() {
        try {
            System.out.println("..............solrIndexingCreator.............................. discussions");
            Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
            String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_DISCUSSION_DATA");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
            Connection con = DBConnector.getInstance().getDBConnection();
            String bibRecCount = "select count(*) from discussion_thread where status='A'";
            int bibCount = 0;
            Statement statx = con.createStatement();
            ResultSet rsCount = statx.executeQuery(bibRecCount);
            while (rsCount.next()) {
                bibCount = rsCount.getInt(1);
            }
            rsCount.close();
            statx.close();
            if (bibCount > 0) {
                int iterationVal = bibCount / 500;
                if (bibCount / 500 != 0) {
                    ++iterationVal;
                }
                if (bibCount < 500) {
                    ++iterationVal;
                }
                boolean incrementVal = false;
                String query = "Begin work;declare catalogue cursor for select * from discussion_thread where status='A'";
                statx = con.createStatement();
                statx.execute(query);
                int count = 0;
                for (int x = 0; x < iterationVal; ++x) {
                    String newQuery = "fetch forward 500 from catalogue";
                    Statement stat = con.createStatement();
                    ResultSet rs = stat.executeQuery(newQuery);
                    Vector<SolrInputDocument> vecFlush = new Vector<SolrInputDocument>();
                    System.out.println("Pooling 500 records.... A total of " + count + " are indexed so far");
                    while (rs.next()) {
                        String id = rs.getString("id");
                        String discussionId = rs.getString("discussion_id");
                        String patronId = rs.getString("patron_id");
                        String libraryId = rs.getString("library_id");
                        String content = rs.getString("content");
                        Timestamp postedOn = rs.getTimestamp("posted_on");
                        Statement stat1 = con.createStatement();
                        ResultSet rs1 = stat1.executeQuery("select * from discussion where id=" + discussionId);
                        String title = "";
                        while (rs1.next()) {
                            title = rs1.getString("title");
                        }
                        rs1.close();
                        stat1.close();
                        SolrInputDocument solrInputDocument = new SolrInputDocument();
                        solrInputDocument.addField("ID", (Object)id);
                        solrInputDocument.addField("DISCUSSION_ID", (Object)discussionId);
                        solrInputDocument.addField("PATRON_ID", (Object)patronId);
                        solrInputDocument.addField("LIBRARY_ID", (Object)libraryId);
                        solrInputDocument.addField("TITLE", (Object)title);
                        solrInputDocument.addField("CONTENT", (Object)content);
                        solrInputDocument.addField("POSTED_ON", (Object)postedOn);
                        vecFlush.addElement(solrInputDocument);
                        ++count;
                    }
                    rs.close();
                    stat.close();
                    System.out.println("Committing: " + vecFlush.size());
                    server.add(vecFlush);
                    server.commit();
                }
                statx.close();
                statx = con.createStatement();
                statx.execute("CLOSE catalogue");
                statx.close();
                con.close();
            } else {
                System.out.println("########### There is no data is available in the Database ##############");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

