/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.goldang.qaparadigm.Dialog;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.FullFrame;
import org.goldang.qaparadigm.InsetPanel;
import org.goldang.qaparadigm.SentenceFile;
import org.goldang.qaparadigm.Strings;

class SequenceIndexDialog
extends Dialog
implements ChangeListener,
ActionListener {
    private final DisplayPanel myDisplay;
    private final JSpinner mySpinner;

    SequenceIndexDialog(FullFrame fFrame) {
        super((Frame)fFrame, Strings.res(Strings.SENTENCE_NUMBER));
        this.myDisplay = fFrame.getDisplayPanel();
        SentenceFile sf = fFrame.getApp().getSentenceFile();
        int nSentences = sf.numberOfSentences();
        int currSentenceNo = sf.sequenceIndex() + 1;
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.mySpinner = new JSpinner(new SpinnerNumberModel(currSentenceNo, 1, nSentences, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.mySpinner);
        editor.getFormat().applyPattern("0");
        this.mySpinner.setEditor(editor);
        this.mySpinner.addChangeListener(this);
        InsetPanel iPanel = new InsetPanel(true);
        iPanel.add(this.mySpinner);
        this.add(iPanel);
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BoxLayout(bPanel, 0));
        JButton cancelBtn = new JButton(Strings.res(Strings.CANCEL));
        bPanel.add(cancelBtn);
        JButton okButton = new JButton(Strings.res(Strings.OK));
        bPanel.add(okButton);
        this.add(bPanel);
        cancelBtn.addActionListener(this);
        okButton.addActionListener(this);
        this.pack();
        this.setSize(200, this.getSize().height);
        this.center();
        this.setVisible(true);
    }

    public void stateChanged(ChangeEvent e) {
        try {
            this.mySpinner.commitEdit();
        }
        catch (ParseException pe) {
            JComponent editor = this.mySpinner.getEditor();
            if (editor instanceof JSpinner.NumberEditor) {
                JSpinner.NumberEditor neditor = (JSpinner.NumberEditor)editor;
                Object val = this.mySpinner.getValue();
                neditor.getTextField().setValue(val);
            }
            this.mySpinner.setValue(1);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == Strings.res(Strings.CANCEL)) {
            this.setVisible(false);
        }
        if (e.getActionCommand() == Strings.res(Strings.OK)) {
            SpinnerModel model = this.mySpinner.getModel();
            if (model instanceof SpinnerNumberModel) {
                SpinnerNumberModel nModel = (SpinnerNumberModel)model;
                this.setSentenceNoFromSpinner(nModel);
            }
            this.setVisible(false);
        }
    }

    private void setSentenceNoFromSpinner(SpinnerNumberModel nModel) {
        int i = nModel.getNumber().intValue() - 1;
        this.myDisplay.showStimulusIndexed(i);
    }
}

