//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_COMMAND
#define FLXBASE_FLX_COMMAND

#include <string>
#include "flxbase\strings.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\string_utils.h"
#include "flxbase\scripts.h"


/*****************************************************************************/

class FlxCommand {
 protected:
  void *d_function_ptr;
public:
  FlxCommand(void){}
  virtual ~FlxCommand(void){}
  virtual bool execute_command(int argc,string *argv) = 0;
};

/*****************************************************************************/

class FlxNoArgCommand : public FlxCommand {
  typedef bool (*FlxNoArgFunctionPtr)(void);
  FlxNoArgFunctionPtr d_function_ptr;
public:
  FlxNoArgCommand(FlxNoArgFunctionPtr function_ptr) : d_function_ptr(function_ptr) {}
  ~FlxNoArgCommand(void){}
  bool execute_command(int argc,string *argv);
};

/* because execute_command isn't a template function, it's defined in
   FlxCommand.cpp rather than here */

/*****************************************************************************/

FLX_LINKAGE extern void apply_opt_args(int &argc,string *argv,string *opt_args,int args_required);

/*****************************************************************************/

template <class A> class FlxOneArgCommand : public FlxCommand {
  typedef bool (*FlxOneArgFunctionPtr)(A *);
  FlxOneArgFunctionPtr d_function_ptr;
  string d_optional_argument;
public:
  FlxOneArgCommand(FlxOneArgFunctionPtr function_ptr,const string &optional_argument) : d_function_ptr(function_ptr), d_optional_argument(optional_argument) {}
  ~FlxOneArgCommand(void){}
  bool execute_command(int argc,string *argv);
};

template <class A>
bool FlxOneArgCommand<A>::execute_command(int argc,string *argv){
  string cur_function="execute_command";
  A *arg1=NULL;

  // apply any optional argument, if necessary
  apply_opt_args(argc,argv,&d_optional_argument,1);

  // actually execute the command
  if(argc!=1){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+flx_cur_script_command+" requires one argument");
    return false;
  } else {
    if(flx_type_convert(argv[0],arg1)){
      return d_function_ptr(arg1);
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Argument is the wrong type, skipping command");
      return false;
    }
  }
}

/*****************************************************************************/

template <class A,class B> class FlxTwoArgCommand : public FlxCommand {
  typedef bool (*FlxTwoArgFunctionPtr)(A *,B *);
  FlxTwoArgFunctionPtr d_function_ptr;
  string d_optional_arguments[2];
public:
  FlxTwoArgCommand(FlxTwoArgFunctionPtr function_ptr,const string &optional_argument1,const string &optional_argument2) : d_function_ptr(function_ptr) {
    d_optional_arguments[0]=optional_argument1;
    d_optional_arguments[1]=optional_argument2;
}
  ~FlxTwoArgCommand(void){}
  bool execute_command(int argc,string *argv);
};

template <class A,class B>
bool FlxTwoArgCommand<A,B>::execute_command(int argc,string *argv){
  string cur_function="execute_command";
  A *arg1=NULL;
  B *arg2=NULL;

  // apply optional arguments if necessary
  apply_opt_args(argc,argv,d_optional_arguments,2);

  // execute the command
  if(argc!=2){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+flx_cur_script_command+" requires two arguments");
    return false;
  } else {
    if(flx_type_convert(argv[0],arg1) && flx_type_convert(argv[1],arg2)){
      return d_function_ptr(arg1,arg2);
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Argument is the wrong type, skipping command");
      return false;
    }
  }
}

/*****************************************************************************/

template <class A,class B,class C> class FlxThreeArgCommand : public FlxCommand {
  typedef bool (*FlxThreeArgFunctionPtr)(A *,B *,C *);
  FlxThreeArgFunctionPtr d_function_ptr;
  string d_optional_arguments[3];
public:
  FlxThreeArgCommand(FlxThreeArgFunctionPtr function_ptr,const string &optional_argument1,const string &optional_argument2,const string &optional_argument3) : d_function_ptr(function_ptr) {
    d_optional_arguments[0]=optional_argument1;
    d_optional_arguments[1]=optional_argument2;
    d_optional_arguments[2]=optional_argument3;
}
  ~FlxThreeArgCommand(void){}
  bool execute_command(int argc,string *argv);
};

template <class A,class B,class C>
bool FlxThreeArgCommand<A,B,C>::execute_command(int argc,string *argv){
  string cur_function="execute_command";
  A *arg1=NULL;
  B *arg2=NULL;
  C *arg3=NULL;

  // apply optional arguments if necessary
  apply_opt_args(argc,argv,d_optional_arguments,3);

  // execute the command
  if(argc!=3){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+flx_cur_script_command+" requires three arguments");
    return false;
  } else {
    if(flx_type_convert(argv[0],arg1) && flx_type_convert(argv[1],arg2) && flx_type_convert(argv[2],arg3)){
      return d_function_ptr(arg1,arg2,arg3);
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Argument is the wrong type, skipping command");
      return false;
    }
  }
}

/*****************************************************************************/

template <class A,class B,class C,class D> class FlxFourArgCommand : public FlxCommand {
  typedef bool (*FlxFourArgFunctionPtr)(A *,B *,C *,D *);
  FlxFourArgFunctionPtr d_function_ptr;
  string d_optional_arguments[4];
public:
  FlxFourArgCommand(FlxFourArgFunctionPtr function_ptr,const string &optional_argument1,const string &optional_argument2,const string &optional_argument3,const string &optional_argument4) : d_function_ptr(function_ptr) {
    d_optional_arguments[0]=optional_argument1;
    d_optional_arguments[1]=optional_argument2;
    d_optional_arguments[2]=optional_argument3;
    d_optional_arguments[3]=optional_argument4;
}
  ~FlxFourArgCommand(void){}
  bool execute_command(int argc,string *argv);
};

template <class A,class B,class C,class D>
bool FlxFourArgCommand<A,B,C,D>::execute_command(int argc,string *argv){
  string cur_function="execute_command";
  A *arg1=NULL;
  B *arg2=NULL;
  C *arg3=NULL;
  D *arg4=NULL;

  // apply optional arguments if necessary
  apply_opt_args(argc,argv,d_optional_arguments,4);

  // execute the command
  if(argc!=4){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+flx_cur_script_command+" requires four arguments");
    return false;
  } else {
    if(flx_type_convert(argv[0],arg1) && flx_type_convert(argv[1],arg2) && flx_type_convert(argv[2],arg3) && flx_type_convert(argv[3],arg4)){
      return d_function_ptr(arg1,arg2,arg3,arg4);
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Argument is the wrong type, skipping command");
      return false;
    }
  }
}

/*****************************************************************************/

#endif
