//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_DUPLEX_LIST
#define FLXBASE_FLX_DUPLEX_LIST

#include <stdlib.h>
#include "flxbase\FlxLinkedList.h"

template <class T,class T2> class FlxDuplexListItem; /* This lets the
		compiler know that there is a class FlxDuplexListItem,
		so the reference to it in the definition of
		FlxDuplexList doesn't produce an error. */

template <class T,class T2>
class FlxDuplexList : public FlxLinkedList<T> {
 public:
  FlxDuplexList(void) {}
  ~FlxDuplexList(void) { remove_all(); }
  void insert(T new_item,T2 new_item2){ insert_item(new FlxDuplexListItem<T,T2>(new_item,new_item2)); }
  void insert_at_beginning(T new_item,T2 new_item2){ insert_item_at_beginning(new FlxDuplexListItem<T,T2>(new_item,new_item2)); }
  void remove(void){ delete static_cast<FlxDuplexListItem<T,T2> *>(this->remove_item()); }
  void remove_all(void){ this->rewind(); while(this->d_list) remove(); }
  T2 *item2(void) { return (this->d_cur_item) ? &(static_cast<FlxDuplexListItem<T,T2> *>(this->d_cur_item)->d_item2) : NULL; }
  T *find_item2(const T2 &expression,bool advance=false);
  T *advance_to_item2(const T2 &expression){ return find_item2(expression,true); }
};

template <class T,class T2>
class FlxDuplexListItem : public FlxLinkedListItem<T> {
  T2 d_item2;
 public:
  FlxDuplexListItem(T new_item,T2 new_item2)
    : FlxLinkedListItem<T>(new_item), d_item2(new_item2) {}
  ~FlxDuplexListItem(void) {}
  friend class FlxDuplexList<T,T2>;
};

template <class T,class L>
T* FlxDuplexList<T,L>::find_item2(const L &expression,bool advance){
  /* Returns a pointer to the first item in the list for which <d_item2>
     matches <expression>, starting from <d_cur_item>. If <advance> is
     true, also makes any matching item the current item. */
  FlxDuplexListItem<T,L> *index;

  index=static_cast<FlxDuplexListItem<T,L> *>(this->d_cur_item);
  while(index!=NULL){
    if(index->d_item2==expression){
      if(advance) this->d_cur_item=index;
      return &(index->d_item);
    }
    index=static_cast<FlxDuplexListItem<T,L> *>(index->d_next);
  }
  return NULL;

} /* find_item2 */

#endif





