//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_OBJECT
#define FLXBASE_FLX_OBJECT

#include <string>
#include <typeinfo>
#include <ostream>
#include "flxbase\FlxDataSystem.h"
#include "flxbase\FlxLinkedList.h"
#include "flxbase\linkage.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

/*****************************************************************************/
/* This is a base class for objects created in a script, providing the
   basic functionality shared by all such objects. Note that the default
   <update> function doesn't do anything. Also, this version doesn't
   allow you to initialize the name member via the constructor; use
   FlxNamedObject for that. */   

class FLX_LINKAGE FlxObject {
 protected:
  string d_name;
  string d_scope;
  FlxLinkedList<FlxObject *> d_dependents;
  FlxLinkedList<FlxObject *> d_sources;
 public:
  FlxObject(const string &name);
  virtual ~FlxObject(void);
  string name(void){ return d_name; }
  void set_name(const string &name){ d_name=name; }
  string scope(void){ return d_scope; }
  void add_dependent(FlxObject *dependent){ d_dependents.insert(dependent); }
  void remove_dependent(FlxObject *dependent);
  void add_source(FlxObject *source){ d_sources.insert(source); }
  void remove_source(FlxObject *source);
  bool is_static(void);
  virtual bool update(void){ flx_data->write_message(FLX_DATADDDEBUG,"FlxObject::update","FlxObject: Nothing to update"); return true; }
  virtual void add_to_update_list(FlxLinkedList<FlxObject *> &update_list);
  bool update_object_and_dependents(void);
  void dump_object(void);
  virtual string value_as_string(void){ return string("FlxObject:")+d_name; }
};

/*****************************************************************************/

class FLX_LINKAGE FlxObjectList : public FlxLinkedList<FlxObject *> {
 public:
  FlxObjectList(void){}
  ~FlxObjectList(void){}
  FlxObject **find_name(const string &name,bool advance=false);
  FlxObject **find_scope(const string &scope,bool advance=false);
  void dump_list(void);
};

class FlxObjectListItem : public FlxLinkedListItem<FlxObject *> {
 public:
  FlxObjectListItem(FlxObject *new_item)
    : FlxLinkedListItem<FlxObject *>(new_item){}
  ~FlxObjectListItem(void) {}
  friend class FlxObjectList;
};

/*****************************************************************************/

FLX_LINKAGE extern FlxObjectList flx_object_list;

/*****************************************************************************/

#endif
