//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_EVENT_HOOKS
#define FLXBASE_EVENT_HOOKS

#include <string>

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

#define FLX_EVENT_HOOK_EARLY 0
#define FLX_EVENT_HOOK_NORMAL 1
#define FLX_EVENT_HOOK_LATE 2

#define FLX_EVENT_HOOK_PRESESSION 0
#define FLX_EVENT_HOOK_PRETRIAL 1
#define FLX_EVENT_HOOK_WITHINEVENT 2
#define FLX_EVENT_HOOK_POSTTRIAL 3
#define FLX_EVENT_HOOK_POSTSESSION 4

typedef bool (*FlxEventHookPtr)(void);

FLX_LINKAGE extern void flx_add_event_hook(const string &,FlxEventHookPtr,int,int priority=FLX_EVENT_HOOK_NORMAL);

FLX_LINKAGE extern bool flx_execute_event_hooks(int);


#endif
