//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_SCOPES
#define FLXBASE_SCOPES

#include <string>
#include "flxbase\linkage.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

typedef void (*FlxScopeCleanupHook)(const string &);
typedef void (*FlxScopeExitHook)(void);

FLX_LINKAGE extern string flx_cur_scope_tag;

FLX_LINKAGE extern void flx_add_scope_cleanup_hook(const string &,FlxScopeCleanupHook);
FLX_LINKAGE extern void flx_add_scope_exit_hook(const string &,FlxScopeExitHook);
FLX_LINKAGE extern bool flx_begin_scope(const string &);
FLX_LINKAGE extern void flx_end_scope(void);
FLX_LINKAGE extern bool flx_delete_scope(const string &tag=flx_cur_scope_tag);
FLX_LINKAGE extern bool is_nested_scope(const string &tag1,const string &tag2);

#endif
