//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <typeinfo>
#include "flxbase\FlxDataSystem.h"
#include "flxbase\time.h"
#include "flxbase\FlxEvent.h"
#include "flxbase\event_manager.h"

FLX_LINKAGE FlxEvent *flx_cur_event;

long long event_start_time, data_start_time;

/*****************************************************************************/

/** THIS FUNCTION HANDLES TASKS THAT SHOULD BE CARRIED OUT BY ALL FLXEVENTS **/

FLX_LINKAGE void FlxEvent::do_generic_event_processing(void){
  string cur_function="FlxEvent::execute";
  long long current_time;

  /* Reset event and/or data time as appropriate; we only get the 
     time if necessary, as we want to minimize how long this function 
     takes to execute */
  if(*d_event_time_reset_point || *d_data_time_reset_point){
    current_time=flx_get_time();
    if(*d_event_time_reset_point){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Resetting event time");
      event_start_time=current_time;
    }
    if(*d_data_time_reset_point){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Resetting data time");
      data_start_time=current_time;
    }
  }

} /* FlxEvent::do_generic_event_processing */

/*****************************************************************************/

