//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <typeinfo>
#include "flxbase\FlxDataSystem.h"
#include "flxbase\command_manager.h"
#include "flxbase\scripts.h"
#include "flxbase\scopes.h"
#include "flxbase\FlxLinkedList.h"
#include "flxbase\FlxStack.h"
#include "flxbase\time.h"
#include "flxbase\condition_manager.h"
#include "flxbase\strings.h"
#include "flxbase\event_hooks.h"
#include "flxbase\object_manager.h"
#include "flxbase\event_manager.h"
#include "flxbase\FlxGroupingEvent.h"

bool in_session;
FlxStack<long long> event_time_stack, data_time_stack;

/*****************************************************************************/

void GroupingEvent::execute(void){
  string cur_function="GroupingEvent::execute";
  FlxCondition **condition_handle;
  FlxEvent **event_handle;
  bool is_session_event;

  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
  this->do_generic_event_processing();
  
  /* determine if this is a session event, and if so, execute the 
     pre-session hooks */
  if(!in_session){
    in_session=true;
    is_session_event=true;
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Executing pre-session hooks");
    if(!flx_execute_event_hooks(FLX_EVENT_HOOK_PRESESSION)){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Pre-session hooks for '"+d_name+"' failed, aborting experiment");
      flx_force_exit=true;
      return;
    } 
  } else {
    is_session_event=false;
  }

  // if this is a TrialEvent, execute the pre-trial hooks
  if(typeid(*this)==typeid(TrialEvent)){    
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Executing pre-trial hooks for '"+d_name+"'");
    if(!flx_execute_event_hooks(FLX_EVENT_HOOK_PRETRIAL)){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Pre-trial hooks for '"+d_name+"' failed, aborting experiment");
      flx_force_exit=true;
      return;
    }
  }

  /* Reset the condition and execution flags (but not the continue
  condition). We do this before the event loop so that it's possible
  to, e.g., re-use a WaitEvent that was triggered earlier in the
  script. For example, you might want to wait for a key after
  presenting the instructions, as well as during each trial. This way
  the WaitEvent will be reset before the trial begins, so it doesn't
  immediately trigger. Because we do this before the continue
  condition is tested, this usually means that everything will be
  reset after the last trial in a block as well. */
  while((condition_handle=d_sub_event_list.item2())){
	event_handle=d_sub_event_list.item();
	(*condition_handle)->reset();
	(*event_handle)->reset();
	d_sub_event_list.advance(); 
  }
  d_sub_event_list.rewind();

    // store the event & data start times for the calling event
    event_time_stack.push(event_start_time);
	data_time_stack.push(data_start_time);
    // get reference time for current event
    event_start_time=data_start_time=flx_get_time();
    flx_event_time=0;
    flx_data_time=0;

    // loop through the sub-events
    while(!flx_force_exit && d_continue_condition->evaluate()){
      while((condition_handle=d_sub_event_list.item2())){
		if(!flx_force_exit && (*condition_handle)->evaluate()){
			(*(d_sub_event_list.item()))->mark_as_executed();
			(*(d_sub_event_list.item()))->execute();
			flx_execute_event_hooks(FLX_EVENT_HOOK_WITHINEVENT);
		}
		d_sub_event_list.advance();
      }
      d_sub_event_list.rewind();
      flx_execute_event_hooks(FLX_EVENT_HOOK_WITHINEVENT);
    }

    // reset the continue condition
    d_continue_condition->reset();

    // restore the event & data start times of the calling event
    event_start_time=event_time_stack.pop();
    data_start_time=data_time_stack.pop();

    // if this is a TrialEvent, execute the post-trial hooks
    if(typeid(*this)==typeid(TrialEvent)){    
      /* we do the post-event hooks regardless of whether the pre-event
	 hooks failed; it's up to the individual hooks to make sure they
	 don't try to undo something that was never done */
      flx_data->write_message(FLX_DATADEBUG,cur_function,"Executing post-trial hooks for '"+d_name+"'");
      if(!flx_execute_event_hooks(FLX_EVENT_HOOK_POSTTRIAL)){
	flx_data->write_message(FLX_DATAERROR,cur_function,"Post-trial hooks for '"+d_name+"' failed, aborting experiment");
	flx_force_exit=true;
      }
    }

    // if this is a session event, execute the post-session hooks
    if(is_session_event){
      in_session=false;
      flx_data->write_message(FLX_DATADEBUG,cur_function,"Executing post-session hooks");
      if(!flx_execute_event_hooks(FLX_EVENT_HOOK_POSTSESSION)){
	flx_data->write_message(FLX_DATAERROR,cur_function,"Post-trial hooks for '"+d_name+"' failed, aborting experiment");
	flx_force_exit=true;
      }
    } 

} /* GroupingEvent::Execute */

/*****************************************************************************/


