//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <fstream>
#include <sstream>
#include "flxbase\string_utils.h"
#include "flxbase\FlxStack.h"
#include "flxbase\scripts.h"
#include "flxbase\event_manager.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\command_manager.h"
#include "flxbase\scopes.h"
#include "flxbase\FlxTriplexList.h"
#include "flxbase\object_manager.h"
#include "flxbase\FlxCondition.h"
#include "flxbase\condition_manager.h"
#include "flxbase\flxbase.h"

FlxTriplexList<FlxCommand *,string,string> command_list;

/*****************************************************************************/

FlxCommand *find_command(const string &name){
  FlxCommand **item;

  if((item=command_list.find_item2(name))) return *item; else return NULL;

} /* find_command */

/*****************************************************************************/

void remove_commands_by_scope(const string &tag){
  string cur_function="remove_commands_by_scope";

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Removing commands with scope '"+tag+"'");
  while(command_list.advance_to_item3(tag)){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Removing command '"+*(command_list.item2())+"'");
    delete(*(command_list.item()));
    command_list.remove();
  }
  command_list.rewind();

} /* remove_commmands_by_scope */

/*****************************************************************************/

FLX_LINKAGE bool flx_do_add_command(const string &name,FlxCommand *cp){
  string cur_function="flx_do_add_command";

  if(command_list.find_item2(name)){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Can't create a command named '"+name+"' because a command with that name already exists");
    return false;
  } else {
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Adding command '"+name+"'");
    command_list.insert(cp,name,flx_cur_scope_tag);
    return true;
  }

} /* flx_do_add_command */

/*****************************************************************************/

FLX_LINKAGE bool flx_add_command(const string &name,bool (*p)(void)){

  return flx_do_add_command(name,new FlxNoArgCommand(p));

} /* flx_add_command */

/*****************************************************************************/

FLX_LINKAGE void reorder_opt_args(string *opt_args,int args_required){
  string cur_function="reorder_opt_args";
  int args_provided;
  string temp;
  int i, j;
  string argument_string;

  /* If only some optional argument values are provided, then the
     order in which they are passed to <flx_add_command> will not be
     the correct order for passing them to the command function. This
     function reorders them as appropriate. */

  // first count how many optional arguments were provided
  args_provided=0;
  for(i=0;i<args_required;i++){
    if(opt_args[i]!="NOOPT"){
      args_provided++;
    }
  }

  // now rotate the optional arguments by as many positions as arguments
  // were provided
  for(i=0;i<args_provided;i++){
    temp=opt_args[0];
    for(j=0;j<args_required-1;j++){
      opt_args[j]=opt_args[j+1];
    }
    opt_args[args_required-1]=temp;
  }

  for(i=0;i<args_required;i++){
    argument_string+=" '";
    argument_string+=opt_args[i];
    argument_string+="'";
  }
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Default arguments are "+argument_string);
    
} /* reorder_opt_args */

/*****************************************************************************/

FLX_LINKAGE bool flx_execute_command(const string &command_name,int argc,string *argv){
  string cur_function="flx_execute_command";
  FlxCommand *cp;
  
  flx_data->write_message(FLX_DATADEBUG,cur_function,"Looking up command '"+flx_cur_script_command+"'");
  if((cp=find_command(command_name))){
    // execute the command
    if(cp->execute_command(argc,argv)){
      return true;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Command "+command_name+" failed");
      return false;
    }
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": No command named "+command_name);
    return false;
  }

} /* flx_execute_command */

/*****************************************************************************/
 
class CommandEvent : public FlxEvent {
  string *d_command_string;
public:
  CommandEvent(const string &name,string *command_string) : FlxEvent(name), d_command_string(command_string){}
  ~CommandEvent(void) {}
  void execute(void);   
};

void CommandEvent::execute(void){
  string cur_function="CommandEvent::execute";

  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
  this->do_generic_event_processing();
  flx_evaluate_script_line(*d_command_string); 

}

/*****************************************************************************/

bool NewCommandEvent(string *name,string *command_string){
  string cur_function="NewCommandEvent";
  CommandEvent *cep;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new CommandEvent '"+*name+"'");
  cep=new CommandEvent(*name,command_string);
  flx_add_scalar_source(cep,command_string);
  return true;
 
} /* NewCommandEvent */
                                                                               
/*****************************************************************************/

bool If(FlxCondition *cp,string *if_command_string,string *else_command_string){
  string cur_function="If";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Conducting if test");
  if(cp->evaluate()){
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Condition is true, executing 'if' command");
    flx_evaluate_script_line(*if_command_string);
  } else {
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Condition is false, executing 'else' command");
	flx_evaluate_script_line(*else_command_string);
  }
  return true;

} /* If */

/*****************************************************************************/

void flx_command_manager_init(void){

  flx_add_command("CommandEvent",NewCommandEvent);
  flx_add_command("If",If,"");
  flx_add_scope_cleanup_hook("remove_commmands_by_scope",remove_commands_by_scope);

} /* flx_command_manager_init */

/*****************************************************************************/


