//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <typeinfo>
#include "flxbase\FlxDataSystem.h"
#include "flxbase\command_manager.h"
#include "flxbase\scopes.h"
#include "flxbase\FlxTriplexList.h"
#include "flxbase\FlxStack.h"
#include "flxbase\time.h"
#include "flxbase\condition_manager.h"
#include "flxbase\strings.h"
#include "flxbase\event_hooks.h"

/*****************************************************************************/

typedef FlxTriplexList<FlxEventHookPtr,string,string> EventHookList;
EventHookList pre_session_hooks[3];
EventHookList pre_trial_hooks[3];
EventHookList within_event_hooks[3];
EventHookList post_trial_hooks[3];
EventHookList post_session_hooks[3];

EventHookList *event_hook_lists[]={ pre_session_hooks, pre_trial_hooks, within_event_hooks, post_trial_hooks, post_session_hooks };
string event_hook_list_labels[]={ "pre-session", "pre-trial", "within-event", "post-trial", "post-session" };
bool event_hook_list_reverse_flags[]={ false, false, false, true, true };
string event_hook_priority_labels[]={ "early", "normal", "late" };

/*****************************************************************************/

void remove_event_hooks_by_scope(const string &tag){
  string cur_function="remove_event_hooks_by_scope";
  int i, j;

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Removing event hooks with scope '"+tag+"'");
  for(i=0;i<5;i++){
    for(j=0;j<3;j++){
      while(event_hook_lists[i][j].advance_to_item3(tag)){
	flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Removing "+event_hook_list_labels[i]+" hook '"+*(event_hook_lists[i][j].item2())+"' (priority "+event_hook_priority_labels[j]+")");
	event_hook_lists[i][j].remove();
      }
      event_hook_lists[i][j].rewind();
  }
  }

} /* remove_event_hooks_by_scope */



/*****************************************************************************/

FLX_LINKAGE void flx_add_event_hook(const string &label,FlxEventHookPtr h,int list,int priority){
  string cur_function="flx_add_event_hook";

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Adding "+event_hook_list_labels[list]+" hook '"+label+"' (priority "+event_hook_priority_labels[priority]+")");
	if(event_hook_list_reverse_flags[list]){
		event_hook_lists[list][priority].insert_at_beginning(h,label,flx_cur_scope_tag);
	} else {
		event_hook_lists[list][priority].insert(h,label,flx_cur_scope_tag);
	}

} /* flx_add_event_hook */

/*****************************************************************************/

FLX_LINKAGE bool flx_execute_event_hooks(int l){
  int i;
  FlxEventHookPtr *hook;
  bool result=true;
  
  if(event_hook_lists[l]){
    for(i=0;i<3;i++){
      while((hook=event_hook_lists[l][i].item())){
	if(!(**hook)()){
	  result=false;
	  break;
	}
	event_hook_lists[l][i].advance();
      }
      event_hook_lists[l][i].rewind();
      if(!result) break;
    }
    return result;
  } else {
    return true;
  }

} /* flx_execute_event_hooks */

/*****************************************************************************/

void flx_event_hooks_init(void){

  flx_add_scope_cleanup_hook("remove_event_hooks_by_scope",remove_event_hooks_by_scope);

} /* flx_event_hooks_init */

/*****************************************************************************/

