//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 

#include <fstream>
#include "flxbase\file_system.h"
#include "flxbase\OS_specific_file_system.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\FlxDuplexList.h"
#include "flxbase\strings.h"
#include "flxbase\scripts.h"
#include "flxbase\command_manager.h"
#include "flxbase\flxbase.h"
#include "flxbase\scopes.h"
#include "flxbase\object_manager.h"

FlxDuplexList<string,string> search_directory_list;

/*****************************************************************************/

 FLX_LINKAGE string flx_extract_path(const string &file_path){
	 string::size_type separator_offset;

 if((separator_offset=file_path.find_last_of(flx_path_separator))!=string::npos){
	return file_path.substr(0,separator_offset+1);
 } else {
	 return string("");
 }

} /* flx_extract_path */

/*****************************************************************************/

 FLX_LINKAGE string flx_extract_filename(const string &file_path){
	 string::size_type separator_offset;

 if((separator_offset=file_path.find_last_of(flx_path_separator))!=string::npos){
	return file_path.substr(separator_offset+1);
 } else {
	 return file_path;
 }

 } /* flx_extract_filename */

/*****************************************************************************/

 FLX_LINKAGE string flx_extract_basename(const string &file_path){
	string file_name;
	string::size_type suffix_offset;

	file_name=flx_extract_filename(file_path);
	if((suffix_offset=file_name.find_last_of("."))!=string::npos){
		return file_name.substr(0,suffix_offset);
	} else {
		return file_name;
	}

 } /* flx_extract_basename */

 /*****************************************************************************/

 FLX_LINKAGE string flx_extract_extension(const string &file_path){
	 string::size_type suffix_offset;
	 string file_name;

	 file_name=flx_extract_filename(file_path);
	 if((suffix_offset=file_name.find_last_of("."))!=string::npos){
	     return file_name.substr(suffix_offset+1);
	 } else {
	     return string("");
	 }

 } /* flx_extract_extension */

/*****************************************************************************/

FLX_LINKAGE string flx_expand_new_filename(const string &file_name){
  string cur_function="flx_expand_new_filename";
  string *search_dir;
  string expanded_file_name;

  flx_data->write_message(FLX_DATADEBUG,cur_function,"Expanding new filename '"+file_name+"'");
  if(flx_is_absolute_path(file_name)){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"File name is an absolute path, no expansion necessary");
    return file_name;
  } else {
    /* if we have a relative path, the name of the most recently added
     search directory (typically the directory containing the
     executing script) is prepended */
    search_dir=search_directory_list.item();
    if(search_dir){
      expanded_file_name=*(search_dir)+file_name;
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Expanded relative file name to '"+expanded_file_name+"'");
      return expanded_file_name;
    } else { // no search directories, just return the name unaltered
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Can't expand relative file name, returning name unaltered");
      return file_name;
    }
  }

} /* flx_expand_new_filename */

/*****************************************************************************/

void do_flx_add_search_directory(const string &directory,int data_level){
  string cur_function="do_flx_add_search_directory";
  string formatted_directory;

  /* if the directory name doesn't already end with a path separator, add it */
  if(directory.size() && directory.substr(directory.size()-1,1)!=flx_path_separator){
    formatted_directory=directory+flx_path_separator;
  } else {
    formatted_directory=directory;
  }

  flx_data->write_message(data_level,cur_function,"Adding search directory '"+formatted_directory+"'");

  /* Note that we add the directory to the list, even if it is in the list
     already. This is because it is possible to add a directory twice but
     with different scopes, in which case we want it to remain in the list
     until both of the scopes have ended. */
  search_directory_list.insert_at_beginning(formatted_directory,flx_cur_scope_tag);

} /* do_flx_add_search_directory */

/*****************************************************************************/

FLX_LINKAGE void flx_add_search_directory(const string &directory){

  do_flx_add_search_directory(directory,FLX_DATADEBUG);

} /* flx_add_search_directory */

/*****************************************************************************/

FLX_LINKAGE bool flx_create_file(const string &filename){
	ofstream *file_stream;

	file_stream=new ofstream(filename.c_str());
	if(!*file_stream){
		return false;
	} else {
		file_stream->close();
		delete file_stream;
		return true;
	}

} /* flx_create_file */

/*****************************************************************************/

bool AddSearchDirectory(string *path){

  do_flx_add_search_directory(*path,FLX_DATASCRIPT);
  return true;

} /* AddSearchDirectory */

/*****************************************************************************/

void remove_search_directories_by_scope(const string &tag){
  string cur_function="remove_search_directories_by_scope";

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Removing search directories with scope '"+tag+"'");
  while(search_directory_list.advance_to_item2(tag)){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Removing search directory '"+*(search_directory_list.item())+"'");
    search_directory_list.remove();
  }
  search_directory_list.rewind();

} /* remove_search_directories_by_scope */

/*****************************************************************************/

void flx_file_system_init(void){

  flx_add_command("AddSearchDirectory",AddSearchDirectory);
  flx_create_scalar_object("path_separator",&flx_path_separator);
  flx_add_search_directory(flxlab_dir);
  flx_add_search_directory(flx_current_working_directory());
  flx_add_scope_cleanup_hook("remove_search_directories_by_scope",remove_search_directories_by_scope);

} /* flx_file_system_init */

/*****************************************************************************/
