//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include "flxbase\object_manager.h"
#include "flxbase\FlxDuplexList.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\strings.h"
#include "flxbase\string_utils.h"
#include "flxbase\scripts.h"
#include "flxbase\logical_and_numeric_types.h"
#include "flxbase\command_manager.h"

/*****************************************************************************/

FLX_LINKAGE long *flx_long(long l){

  return flx_X(l);
}

FLX_LINKAGE bool *flx_bool(bool b){

  return flx_X(b);
}

FLX_LINKAGE float *flx_float(float f){

  return flx_X(f);
}

/*****************************************************************************/

void flx_string_to_X(bool &b,const string &s,bool *err_flag){
  b=flx_string_to_bool(s,err_flag);
}

void flx_string_to_X(long &l,const string &s,bool *err_flag){
  l=flx_string_to_long(s,err_flag);
}

void flx_string_to_X(float &f,const string &s,bool *err_flag){
  f=flx_string_to_float(s,err_flag);
}

template <class T>
bool flx_scalar_convert(const string &s,T *&xp,const string &type_name){
  string cur_function="flx_type_convert";
  string clean_s;
  T *old_xp;
  T x;
  FlxScalarObject<T> *xop;
  bool err_flag;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converting '"+s+"' to a "+type_name);
  if(s.size() && s[0]=='$'){ // we have a variable name
    clean_s=s.substr(1); // strip off the leading $
    old_xp=xp;
    // try to convert to the appropriate type
    xop=flx_get_object_by_name<FlxScalarObject<T> >(clean_s);
    if(xop){
      xp=xop->value();
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a variable");
      return true;
    } 
    // try an implicit conversion from a string
    xp=flx_implicit_scalar_conversion<T>(clean_s);
    if(xp){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Did implicit conversion from a string variable");
      return true;
    }
    // can't find an appropriate variable
    flx_data->write_message(FLX_DATAERROR,cur_function,"There is no "+type_name+" variable named '"+clean_s+"', and can't find a string variable to convert from");
    xp=old_xp;
    return false;
  } else { // we have a literal value
    flx_string_to_X(x,s,&err_flag);
    if(err_flag){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Can't convert '"+s+"' to a literal "+type_name+" value");
      return false;
    } else {
      if(xp){
	*xp=x;
      } else {
	xp=flx_X(x);
      }
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a literal value");
      return true;
    }
  }
}

FLX_LINKAGE bool flx_type_convert(const string &s,long *&lp){

  return flx_scalar_convert(s,lp,"long integer");
}

FLX_LINKAGE bool flx_type_convert(const string &s,bool *&bp){

  return flx_scalar_convert(s,bp,"bool");
}

FLX_LINKAGE bool flx_type_convert(const string &s,float *&fp){

  return flx_scalar_convert(s,fp,"float");
}

/*****************************************************************************/

bool NewCounter(string *name,long *value){
	string cur_function="NewCounter";
	FlxScalarObject<long> *counter;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new counter '"+*name+"' with initial value "+flx_convert_to_string(*value));
  counter=new FlxScalarObject<long>(*name);
  /* We have the object allocate new storage for the counter because
     <value> just specifies the initial value for the counter; we
     don't want the counter to change its value whenever <value>
     does. For the same reason, we don't make the counter dependent on
     <value>. */
  counter->set_value(*value);
  return true;

} /* NewCounter */

/*****************************************************************************/

bool Increment(long *value,long *increment){
	string cur_function="Increment";

	*value+=*increment;
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Incrementing variable by "+flx_convert_to_string(*increment)+"; new value is "+flx_convert_to_string(*value));

	return true;

} /* Increment */

/*****************************************************************************/

void flx_logical_and_numeric_types_init(void){

  flx_add_command("Counter",NewCounter,"0");
  flx_add_command("Increment",Increment,"1");
  
} /* flx_logical_and_numeric_types_init */

/*****************************************************************************/

