//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxbase\flxbase.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\strings.h"
#include "flxbase\command_manager.h"
#include "flxbase\scripts.h"
#include "flxbase\scopes.h"
#include "flxbase\FlxTriplexList.h"

FlxTriplexList<FlxLinkedList<string> *,string,string> macro_list;

/*****************************************************************************/

bool ExecuteMacro(FlxLiteralString *raw_arg1,FlxLiteralString *raw_arg2,FlxLiteralString *raw_arg3,FlxLiteralString *raw_arg4){
  string cur_function="ExecuteMacro";
  FlxLinkedList<string> **macro_lines;
  string *raw_args[] = { raw_arg1, raw_arg2, raw_arg3, raw_arg4 };
  string args[4];
  string *raw_next_line, next_line;
  unsigned int i;

  if((macro_lines=macro_list.find_item2(flx_cur_script_command))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Executing macro '"+flx_cur_script_command+"'");
    /* If any of the arguments were surrounded by quotes, the quotes
       got stripped by this point, which means that multi-word
       arguments will just look like multiple arguments to the
       commands within the macro. Thus, we surround any multi-word
       arguments with quotes. */
    for(i=0;i<4;i++){
      if(raw_args[i]->find_first_of(" \t")!=string::npos){ 
	args[i]="\""+*(raw_args[i])+"\"";
      } else {
	args[i]=*(raw_args[i]);
      }
    }

    while((raw_next_line=(*macro_lines)->item()) && !abort_flxlab){
      flx_data->write_message(FLX_DATADDEBUG,cur_function,"Evaluating macro line '"+*raw_next_line+"'");
      /* Substitute for macro arguments. Note that the substituted text is
	 itself checked for further expansions. */
      next_line=*raw_next_line;
      i=0;
      while(i<next_line.size()-1){
	if(next_line.substr(i,2)=="$1"){
	  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Replacing parameter $1 with '"+args[0]+"'");
	  next_line.replace(i,2,args[0]);
	} else if(next_line.substr(i,2)=="$2"){
	  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Replacing parameter $2 with '"+args[1]+"'");
	  next_line.replace(i,2,args[1]);
	} else if(next_line.substr(i,2)=="$3"){
	  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Replacing parameter $3 with '"+args[2]+"'");
	  next_line.replace(i,2,args[2]);
	} else if(next_line.substr(i,2)=="$4"){
	  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Replacing parameter $4 with '"+args[3]+"'");
	  next_line.replace(i,2,args[3]);
	} else {
	  i++;
	}
      }
      flx_evaluate_script_line(next_line);
      (*macro_lines)->advance();
    }
    (*macro_lines)->rewind();
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Attempt to execute unknown macro '"+flx_cur_script_command+"'");
    return false;
  }

} /* ExecuteMacro */

/*****************************************************************************/

bool DefineMacro(string *name){
  string cur_function="DefineMacro";
  FlxLinkedList<string> *macro_lines;
  string next_line;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Defining macro '"+*name+"'");
  macro_lines=new FlxLinkedList<string>();
  while(flx_get_script_line(next_line) && next_line!="EndMacro"){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Adding line '"+next_line+"'");
    macro_lines->insert(next_line);
  }
  if(next_line=="EndMacro"){
    macro_list.insert(macro_lines,*name,flx_cur_scope_tag);
    flx_add_command(*name,ExecuteMacro,"","","","");
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Macro '"+*name+"' does not end with EndMacro");
    delete(macro_lines);
    return false;
  }

} /* DefineMacro */

/*****************************************************************************/

void remove_macros_by_scope(const string &tag){
  string cur_function="remove_macros_by_scope";

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Removing macros with scope '"+tag+"'");
  while(macro_list.advance_to_item3(tag)){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Removing macro '"+*(macro_list.item2())+"'");
    delete(*(macro_list.item()));
    macro_list.remove();
  }
  macro_list.rewind();

} /* remove_macros_by_scope */

/*****************************************************************************/

void flx_macros_init(void){

  flx_add_command("DefineMacro",DefineMacro);
  flx_add_scope_cleanup_hook("remove_macros_by_scope",remove_macros_by_scope);

} /* flx_macros_init */

/*****************************************************************************/
