//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include "flxbase\FlxDataSystem.h"
#include "flxbase\command_manager.h"
#include "flxbase\event_manager.h"
#include "flxbase\scripts.h"
#include "flxbase\string_utils.h"
#include "flxbase\strings.h"
#include "flxbase\scopes.h"
#include "flxbase\flxbase.h"
#include "flxbase\modules.h"
#include "flxbase\file_system.h"
#include "flxbase\FlxDuplexList.h"
#include "flxbase\OS_specific_modules.h"

FlxDuplexList<string,string> loaded_modules_list;
FlxModuleCallbackPtr module_callback_ptr;

/*****************************************************************************/

bool UseModule(string *module_name){
  string cur_function="UseModule";
  int result;

  if(loaded_modules_list.find_item(*module_name)){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Module '"+*module_name+"' is already loaded, skipping.");
    return true;
  } else {
    result=flx_load_module(*module_name);
    switch(result){
    case FLX_MODFILENOTFOUND:
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Module '"+*module_name+"' does not exist or is not readable.");
      return false;
      break;
    case FLX_MODLOADERROR:
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Error loading module '"+*module_name+"'");
    return false;
    break;
    case FLX_MODOK:
      loaded_modules_list.insert(*module_name,flx_cur_scope_tag);
		/* If the module set a function to be called once it finished loading, 
		call it now */
		if(module_callback_ptr){
			flx_data->write_message(FLX_DATADEBUG,cur_function,"Executing callback function for module '"+*module_name+"'");
			(*module_callback_ptr)();
			module_callback_ptr=NULL;
		}
      flx_data->write_message(FLX_DATASCRIPT,cur_function,"Loaded module '"+*module_name+"'");
      return true;
    break;
    default:
      flx_data->write_message(FLX_DATAERROR,cur_function,"Unknown module result code "+flx_convert_to_string(result));
      return false;
      break;
    }
  }

} /* UseModule */

/*****************************************************************************/

/* This allows the initialization code of a module to set a function that will
be called once the module finishes loading. In Windows at least, certain functions
(e.g., ones that manipulate hardware) seem to crash if they are called during the
module initialization itself. */

FLX_LINKAGE void flx_set_module_post_load_callback(FlxModuleCallbackPtr mcp){
	
	module_callback_ptr=mcp;

} /* flx_set_module_post_load_callback */

/*****************************************************************************/

void unload_modules_by_scope(const string &tag){
  string cur_function="unload_modules_by_scope";

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Unloading modules with scope '"+tag+"'");
  while(loaded_modules_list.advance_to_item2(tag)){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Unloading module '"+*(loaded_modules_list.item())+"'");
    flx_unload_module(*(loaded_modules_list.item()));
    loaded_modules_list.remove();
  }
  loaded_modules_list.rewind();

} /* unload_modules_by_scope */

/*****************************************************************************/

void flx_modules_init(void){

  flx_add_command("UseModule",UseModule);
  flx_add_search_directory(flxlab_dir+"modules"+flx_path_separator);
  flx_add_scope_cleanup_hook("unload_modules_by_scope",unload_modules_by_scope);
  module_callback_ptr=NULL;

} /* modules_init */

/*****************************************************************************/



