/*
 * "Hello, World!" with Glyph Keeper and Allegro
 *
 * Copyright (c) 2003-2007 Kirill Kryukov
 *
 * This file is part of Glyph Keeper library, and may only be used,
 * modified, and distributed under the terms of the Glyph Keeper
 * license, located in the file 'license.txt' within this package.
 */

#include <allegro.h>
#include "glyph.h"


char* fontfile = "DejaVuSans.ttf";
char* font_search_path = "../fonts/";


int main()
{
    GLYPH_FACE* face;
    GLYPH_REND* rend;
    GLYPH_REND* rend2;
    int dcd;

    allegro_init();

    /* Loading a font face from file. */
    gk_set_font_path(font_search_path);
    face = gk_load_face_from_file(fontfile,0);
    if (!face) { allegro_message("Can't load font from \"%s\"\n",fontfile); exit(1); }

    /* Setting up a renderer object. */
    rend = gk_create_renderer(face,0);
    if (!rend) { allegro_message("Can't create text renderer"); exit(1); }
    gk_rend_set_hinting_off(rend);
    gk_rend_set_size_pixels(rend,75,75);
    gk_rend_set_text_color_rgb(rend,69,142,185);



    dcd = desktop_color_depth();
    set_color_depth(dcd?dcd:32);
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0))
        if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,640,480,0,0))
            { allegro_message("Error: can't set graphics mode"); exit(1); }
    clear_to_color(screen,makecol(255,255,255));
    install_keyboard();

    gk_rend_set_angle_in_radians(rend,6.1);

    gk_render_line_utf8(screen,rend,"Hello, World!",50,70);

    gk_rend_set_italic_angle_in_degrees(rend,12);
    gk_render_line_utf8(screen,rend,"Italic!",30,170);
    gk_rend_set_italic_angle_in_degrees(rend,0);

    gk_rend_set_bold_strength(rend,200);
    gk_render_line_utf8(screen,rend,"Bold!",300,220);


    rend2 = gk_create_copy_of_renderer(rend);
    if (!rend2) { allegro_message("Can't create second text renderer"); exit(1); }
    gk_rend_set_bold_strength(rend2,0);
    gk_rend_set_text_color_rgb(rend2,255,255,255);
    gk_rend_set_after_renderer(rend,rend2,0,0);

    gk_render_line_utf8(screen,rend,"Outline!",50,280);

    /*gk_rend_set_bold_strength(rend,100);
    gk_rend_set_bold_strength(rend2,-100);
    gk_render_line_utf8(screen,rend,"MAqkrfnb",20,400);*/


    /*gk_put_char(screen,rend,'A',100,10);*/


    while(!key[KEY_ESC] && !key[KEY_SPACE] && !key[KEY_ENTER]) { rest(1); }
    return 0;
}
END_OF_MAIN()
