//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_COLORS
#define FLXGRAPHICS_COLORS

#include <string>
#include "allegro.h"
#include <flxbase.h>
#include <linkflx.h>

using namespace std;

/*****************************************************************************/

class FLX_LINKAGE FlxColor : public FlxObject {
 protected:
  long *d_red;
  long *d_green;
  long *d_blue;
  string *d_source_string;
public:
 FlxColor(const string &name) : FlxObject(name), d_red(NULL), d_green(NULL), d_blue(NULL), d_source_string(NULL) {}
 FlxColor(const string &name,string *source_string) : FlxObject(name), d_red(NULL), d_green(NULL), d_blue(NULL), d_source_string(source_string) {}
  ~FlxColor(void){}
  void set_red(long *red){ flx_change_scalar_setting(this,d_red,red,"FlxColor::d_red"); }
  void set_green(long *green){ flx_change_scalar_setting(this,d_green,green,"FlxColor::d_green"); }
  void set_blue(long *blue){ flx_change_scalar_setting(this,d_blue,blue,"FlxColor::d_blue"); }
  int red(void){ return *d_red; }
  int green(void){ return *d_green; }
  int blue(void){ return *d_blue; }
  virtual int color_code(void) { return (d_red==NULL || d_green==NULL || d_blue==NULL) ? bitmap_mask_color(screen) : makecol(*d_red,*d_green,*d_blue); }
  bool update(void);
};

/*****************************************************************************/

FLX_LINKAGE extern FlxColor *flx_transparent_color;

FLX_LINKAGE extern bool flx_type_convert(const string &,FlxColor *&);

FLX_LINKAGE extern FlxColor *flx_color(long r,long g,long b);

#endif
