//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_GRAPHICS_EVENTS
#define FLXGRAPHICS_GRAPHICS_EVENTS

#include <flxbase.h>
#include "flxgraphics\positions.h"
#include "flxgraphics\object_boxes.h"
#include <linkflx.h>
extern bool *flx_default_wait_for_refresh;

/*****************************************************************************/

class FlxDisplayEvent : public FlxEvent {
  FlxGraphicsObjectBox *d_object_box;
  FlxPosition *d_position;
  FlxPosition *d_alignment;
  BITMAP *d_display_buffer;
  int d_buffer_offset_x, d_buffer_offset_y;
  bool *d_wait_for_refresh;
public:
  /* need to call FlxObject constructor explicitly due to it being a
   virtual base class of FlxEvent & FlxGraphicsObjectBox */
 FlxDisplayEvent(const string &name,FlxPosition *position,FlxPosition *alignment) : FlxEvent(name), d_object_box(NULL), d_position(NULL), d_alignment(NULL), d_display_buffer(NULL), d_wait_for_refresh(NULL) {
    flx_suspend_setting_updates();
    this->set_wait_for_refresh(flx_default_wait_for_refresh);
    this->set_position(position);
    this->set_alignment(alignment);
    this->set_object_box(new FlxGraphicsObjectBox(name+"_box"));
    d_object_box->set_filled(flx_bool(true));
    flx_resume_setting_updates();
    this->update();
  }
  ~FlxDisplayEvent(){}
  void set_object_box(FlxGraphicsObjectBox *object_box){ flx_change_object_setting(this,d_object_box,object_box,"FlxDisplayEvent::d_object_box"); }
  void set_position(FlxPosition *position){  flx_change_object_setting(this,d_position,position,"FlxDisplayEvent::d_position"); }
  void set_alignment(FlxPosition *alignment){  flx_change_object_setting(this,d_alignment,alignment,"FlxDisplayEvent::d_alignment"); }
  void set_wait_for_refresh(bool *wait_for_refresh){ flx_change_scalar_setting(this,d_wait_for_refresh,wait_for_refresh,"FlxDisplayEvent::d_wait_for_refresh"); }
  FlxGraphicsObjectBox *get_object_box(void){ return d_object_box; }
  bool update(void);
  void execute(void);
};

FLX_LINKAGE extern BITMAP *flx_cur_buffer;

#endif
