//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_IMAGE_OBJECTS
#define FLXGRAPHICS_IMAGE_OBJECTS

#include <string>
#include "flxgraphics\graphics_objects.h"

class FlxImageObject : virtual public FlxGraphicsObject {
 protected:
  string *d_image_file;
  BITMAP *d_image_bitmap;
  /* note that width and height are read-only properties, as they are
     dictated by the size of the image */
  int d_width, d_height;
 public:
  FlxImageObject(const string &name,string *image_file) : FlxGraphicsObject(name), d_image_file(image_file), d_image_bitmap(NULL), d_width(0), d_height(0) {}
  ~FlxImageObject() {}
  int x_size(void) { return d_width; }
  int y_size(void) { return d_height; }
  virtual bool update(void);
  virtual void draw(void);
};

class FlxImagePatternObject : public FlxColoredObject, public FlxImageObject {
 protected:
  BITMAP *d_alpha_bitmap;
 public:
 FlxImagePatternObject(const string &name,string *image_file) : FlxGraphicsObject(name), FlxImageObject(name,image_file) {}
  ~FlxImagePatternObject() {}
  bool update(void);
  void draw(void);
};

#endif
