//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_LINE_OBJECTS
#define FLXGRAPHICS_LINE_OBJECTS

#include "flxgraphics\graphics_objects.h"
#include <linkflx.h>

class FlxLineObject : public FlxColoredObject, public FlxLinedObject {
 protected:
  FlxPosition *d_start, *d_end;
 public:
 FlxLineObject(const string &name,FlxPosition *start,FlxPosition *end) : FlxGraphicsObject(name), d_start(start), d_end(end) {}
  ~FlxLineObject() {}
  void draw(void);
};

class FlxVectorObject : public FlxColoredObject, public FlxLinedObject {
 protected:
  long *d_angle, *d_length;
 public:
  FlxVectorObject(const string &name,long *angle,long *length) : FlxGraphicsObject(name), d_angle(angle), d_length(length) {}
  ~FlxVectorObject() {}
  void draw(void);
};

#endif
