//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_OBJECT_BOXES
#define FLXGRAPHICS_OBJECT_BOXES

#include <flxbase.h>
#include "flxgraphics\colors.h"
#include "flxgraphics\positions.h"
#include "flxgraphics\graphics_objects.h"
#include "flxgraphics\shape_objects.h"
#include <linkflx.h>

/*****************************************************************************/

class FlxGraphicsObjectArrayElement {
  FlxGraphicsObject *d_object;
  FlxPosition *d_position;
  FlxPosition *d_alignment;
 public:
  FlxGraphicsObjectArrayElement(FlxGraphicsObject *object,FlxPosition *position,FlxPosition *alignment) : d_object(object), d_position(position), d_alignment(alignment) {}
  ~FlxGraphicsObjectArrayElement() {}
  FlxGraphicsObject *object(void) { return d_object; }
  FlxPosition *position(void) { return d_position; }
  FlxPosition *alignment(void) { return d_alignment; }
};

/*****************************************************************************/

class FlxGraphicsObjectBox : public FlxRectangleObject {
 protected:
  FlxLinkedList<FlxGraphicsObjectArrayElement> d_object_list;
  public:
 FlxGraphicsObjectBox(const string &name) : FlxGraphicsObject(name), FlxRectangleObject(name) {
    set_color(flx_transparent_color); 
    set_x_size(flx_length(100,FLX_LENGTH_PERCENTAGE)); 
    set_y_size(flx_length(100,FLX_LENGTH_PERCENTAGE));
    set_line_width(flx_long(0));
  }
  ~FlxGraphicsObjectBox() {}
  void add_object(FlxGraphicsObject *op,FlxPosition *pp,FlxPosition *ap) { d_object_list.insert(FlxGraphicsObjectArrayElement(op,pp,ap)); }
  void draw(void);
};

/*****************************************************************************/

#endif
