//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_POSITIONS
#define FLXGRAPHICS_POSITIONS

#include <allegro.h>
#include <flxbase.h>
#include <linkflx.h>

FLX_LINKAGE extern int flx_cur_buffer_offset_x, flx_cur_buffer_offset_y;

class FlxPenLocation {
  int d_cur_x, d_cur_y;
  FlxStack<int> d_x_stack, d_y_stack;
 public:
  FlxPenLocation() : d_cur_x(0), d_cur_y(0) {}
  ~FlxPenLocation() {}
  void move(int x,int y){
    d_cur_x+=x;
    d_x_stack.push(x);
    d_cur_y+=y;
    d_y_stack.push(y);
  }
  int x(void){ return d_cur_x; }
  int screen_x(void){ return 0; }//d_cur_x+flx_cur_buffer_offset_x; }
  int y(void){ return d_cur_y; }
  int screen_y(void){ return 0; }//d_cur_y+flx_cur_buffer_offset_y; }
  void undo_move(void){ 
    d_cur_x-=d_x_stack.pop(); 
    d_cur_y-=d_y_stack.pop();
  }
 void reset(void){ d_cur_x=0; d_cur_y=0; while(d_x_stack.read()) d_x_stack.pop(); while(d_y_stack.read()) d_y_stack.pop(); } 
};

FLX_LINKAGE extern FlxPenLocation *flx_pen;

#define FLX_LENGTH_X 1
#define FLX_LENGTH_Y 2
#define FLX_LENGTH_ABSOLUTE 1
#define FLX_LENGTH_PERCENTAGE 2
#define FLX_LENGTH_UNDEFINED -1

class FLX_LINKAGE FlxLength : public FlxScalarObject<long> {
protected:
  int d_length_type;
public:
 FlxLength(const string &name) : FlxScalarObject<long>(name), d_length_type(FLX_LENGTH_ABSOLUTE) {}
  void set_length_type(int length_type){ d_length_type=length_type; }
  ~FlxLength(void){}
  long value(int dimension);
};

class FlxPosition : public FlxObject {
  FlxLength *d_x_pos;
  FlxLength *d_y_pos;
  string *d_source_string;
public:
 FlxPosition(const string &name) : FlxObject(name), d_source_string(NULL){}
 FlxPosition(const string &name,string *source_string) : FlxObject(name), d_source_string(source_string){}
  ~FlxPosition(void){}
  void set_x(FlxLength *x_pos){ d_x_pos=x_pos; }
  void set_y(FlxLength *y_pos){ d_y_pos=y_pos; }
  long x(void){ return d_x_pos->value(FLX_LENGTH_X); }
  long y(void){ return d_y_pos->value(FLX_LENGTH_Y); }
  bool update(void);
};

extern FlxLength *flx_undefined_length;
extern bool flx_type_convert(const string &,FlxLength *&);
extern bool flx_type_convert(const string &,FlxPosition *&);

FLX_LINKAGE extern FlxLength *flx_length(long length,int length_type);

#endif
