//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_SHAPE_OBJECTS
#define FLXGRAPHICS_SHAPE_OBJECTS

#include "flxgraphics\graphics_objects.h"
#include <linkflx.h>

class FLX_LINKAGE FlxRectangleObject : public FlxColoredObject, public FlxSizedObject, public FlxFilledObject, public FlxLinedObject {
public:
  FlxRectangleObject(string name) : FlxGraphicsObject(name) {}
  ~FlxRectangleObject() {}
  /* we need these size functions because they are not provided by
   FlxSizedObject; see the class declaration for an explanation */
  int x_size(void) { return d_x_size->value(FLX_LENGTH_X); }
  int y_size(void) { return d_y_size->value(FLX_LENGTH_Y); }
  void draw(void);
};

class FlxEllipseObject : public FlxColoredObject, public FlxSizedObject, public FlxFilledObject, public FlxLinedObject {
public:
  FlxEllipseObject(string name) : FlxGraphicsObject(name) {}
  ~FlxEllipseObject() {}
  /* we need these size functions because they are not provided by
   FlxSizedObject; see the class declaration for an explanation */
  int x_size(void) { return d_x_size->value(FLX_LENGTH_X); }
  int y_size(void) { return d_y_size->value(FLX_LENGTH_Y); }
  void draw(void);
};

#endif
