//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include <allegro.h>
#include <flxbase.h>
#include <linkflx.h>
#include "flxgraphics\colors.h"
#include "flxgraphics\positions.h"
#include "flxgraphics\graphics_objects.h"

FLX_LINKAGE FlxGraphicsObject *flx_cur_graphics_object;
FlxStack<FlxGraphicsObject *> flx_reference_graphics_object_stack;

FLX_LINKAGE FlxColor *flx_default_color;
FLX_LINKAGE long *flx_default_line_width;
FLX_LINKAGE FlxLength *flx_default_x_size;
FLX_LINKAGE FlxLength *flx_default_y_size;
FLX_LINKAGE bool *flx_default_filled;

/*****************************************************************************/

FLX_LINKAGE bool flx_type_convert(const string &s,FlxGraphicsObject *&gop){

  return flx_object_convert<FlxGraphicsObject>(s,gop,"FlxGraphicsObject");
} 

/*****************************************************************************/

bool SetColor(FlxColor *cp){
  string cur_function="SetColor";
  FlxColoredObject *cop;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default color attribute");
    flx_change_global_setting(&flx_default_color,cp,"flx_default_color");
    return true;
  } else if((cop=dynamic_cast<FlxColoredObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting color of '"+flx_cur_graphics_object->name()+"'");
    cop->set_color(cp);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a color");
    return false;
  }

} /* SetColor */

/*****************************************************************************/

bool SetLineWidth(long *w){
  string cur_function="SetLineWidth";
  FlxLinedObject *lop;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default line width attribute");
    flx_change_global_setting(&flx_default_line_width,w,"flx_default_line_width");
    return true;
  } else if((lop=dynamic_cast<FlxLinedObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting line width of '"+flx_cur_graphics_object->name()+"'");
    lop->set_line_width(w);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a line width");
    return false;
  }

} /* SetLineWidth */

/*****************************************************************************/

bool SetSize(FlxLength *x,FlxLength *y){
  string cur_function="SetSize";
  FlxSizedObject *sop;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default size attribute");
    flx_change_global_setting(&flx_default_x_size,x,"flx_default_x_size");
    flx_change_global_setting(&flx_default_y_size,y,"flx_default_y_size");
    return true;
  } else if((sop=dynamic_cast<FlxSizedObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting size of '"+flx_cur_graphics_object->name()+"'");
    sop->set_x_size(x);
    sop->set_y_size(y);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a size");
    return false;
  }

} /* SetSize */

/*****************************************************************************/

bool SetFilled(bool *flag){
  string cur_function="SetFilled";
  FlxFilledObject *fop;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default filled attribute");
    flx_change_global_setting(&flx_default_filled,flag,"flx_default_filled");
    return true;
  } else if((fop=dynamic_cast<FlxFilledObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting filled attribute of '"+flx_cur_graphics_object->name()+"'");
    fop->set_filled(flag);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't be filled");
    return false;
  }

} /* SetFilled */

/*****************************************************************************/

bool SelectObject(string *raw_argument){
/* Because the special graphics object 'default' should have all
   possible graphics properties (e.g., color, line width, etc.), we
   can't implement it as an actual object, or modules wouldn't be able
   to add new graphics properties without changing the definition of
   the default object. Thus, the default object is implemented as a
   null pointer. Any routine that sets graphics properties then knows
   that if <flx_cur_graphics_object> is null, it should change the
   default value. The down side of this is that we can't pass in a
   null <FlxObject *> to <SelectObject>, because the
   <flx_type_convert> call to convert the raw argument to a graphics
   object would fail. Thus, we ask for the raw string argument and
   check if it is 'default'.  If so, we set <flx_cur_graphics_object>
   to null, otherwise we convert to a <FlxObject *> and assign the
   result to <flx_cur_graphics_object>. */
  string cur_function="SelectObject";
  FlxGraphicsObject *gop=NULL;

  if(*raw_argument=="default"){
	flx_data->write_message(FLX_DATASCRIPT,cur_function,"Selecting graphics object 'default'");
	flx_change_global_setting(&flx_cur_graphics_object,static_cast<FlxGraphicsObject *>(NULL),"flx_cur_graphics_object");
	return true;
  } else {
	if(flx_type_convert(*raw_argument,gop)){
      flx_data->write_message(FLX_DATASCRIPT,cur_function,"Selecting graphics object '"+gop->name()+"'");
      flx_change_global_setting(&flx_cur_graphics_object,gop,"flx_cur_graphics_object");
       return true;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Argument is the wrong type, skipping command");
      return false;
    }
  }

} /* SelectObject */

/*****************************************************************************/

void flx_graphics_objects_init(void){

  flx_add_command("Color",SetColor);
  flx_add_command("LineWidth",SetLineWidth);
  flx_add_command("Size",SetSize);
  flx_add_command("Filled",SetFilled,"true");
  flx_add_command("SelectObject",SelectObject);

  flx_default_color=flx_color(0,0,0);
  flx_default_line_width=flx_long(1);
  flx_default_x_size=flx_length(10,FLX_LENGTH_ABSOLUTE);
  flx_default_y_size=flx_length(10,FLX_LENGTH_ABSOLUTE);
  flx_default_filled=flx_bool(false);

} /* flx_graphics_objects_init */
  
/*****************************************************************************/
