//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxgraphics\image_objects.h"
#include "flxgraphics\graphics_events.h"
#include <flxbase.h>

/*****************************************************************************/

bool FlxImageObject::update(void){
	string cur_function="FlxImageObject::update";
	string expanded_image_file;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Loading image for '"+d_name+"' from '"+*d_image_file+"'");
  if(d_image_bitmap) destroy_bitmap(d_image_bitmap);
  expanded_image_file=flx_expand_filename(*d_image_file);
  if(expanded_image_file.empty()){
	flx_data->write_message(FLX_DATAERROR,cur_function,"Can't find image file '"+*d_image_file+"'");
    return false;
  } else {
  d_image_bitmap=load_bitmap(expanded_image_file.c_str(),NULL);
  if(d_image_bitmap){
    /* THIS DEPENDS ON THE INTERNAL STRUCTURE OF A BITMAP, SO IT MAY NEED
       TO BE UPDATED WITH FUTURE VERSIONS OF ALLEGRO */
    d_width=d_image_bitmap->w;
    d_height=d_image_bitmap->h;
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Can't load image for '"+d_name+"' from '"+*d_image_file+"'");
    return false;
  }
  }
}

/*****************************************************************************/

void FlxImageObject::draw(void){

  flx_data->write_message(FLX_DATADDDEBUG,"FlxImageObject::draw","Drawing "+flx_convert_to_string(d_width)+"x"+flx_convert_to_string(d_height)+" image '"+d_name+"' at ("+flx_convert_to_string(flx_pen->screen_x())+","+flx_convert_to_string(flx_pen->screen_y())+")");
  if(d_image_bitmap) masked_blit(d_image_bitmap,flx_cur_buffer,0,0,flx_pen->x(),flx_pen->y(),d_width,d_height);
}

/*****************************************************************************/

bool FlxImagePatternObject::update(void){
  string cur_function="FlxImagePatternObject::update";
  int i,j, white_color, flx_transparent_color;
  int pixel_color, alpha_val;  

  if(!FlxImageObject::update()){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Can't create image mask for '"+d_name+"' from '"+*d_image_file+"'");
    return false;
  } else {
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating image mask for '"+d_name+"' from '"+*d_image_file+"'");
      /* convert white pixels intro transparent, all others into the
     color associated with the mask object */
    d_alpha_bitmap=create_bitmap_ex(32,d_image_bitmap->w,d_image_bitmap->h);
    white_color=makeacol(255,255,255,0);
    flx_transparent_color=bitmap_mask_color(d_alpha_bitmap);
    for(i=0;i<d_image_bitmap->w;i++){
      for(j=0;j<d_image_bitmap->h;j++){
	if((pixel_color=getpixel(d_image_bitmap,i,j))==white_color){
	  putpixel(d_alpha_bitmap,i,j,flx_transparent_color);
	} else {
	  /* 0 is max saturation, 255 is min - we subtract
	     from 765=255*3, then divide by 3 to make the
	     calculations more efficient */
	  alpha_val=(765-getr(pixel_color)-getg(pixel_color)-getb(pixel_color))/3;
	  putpixel(d_alpha_bitmap,i,j,makeacol(d_color->red(),d_color->green(),d_color->blue(),alpha_val));
	} 
      } 
    } 
    return true;
  }
}

/*****************************************************************************/

void FlxImagePatternObject::draw(void){
  
  flx_data->write_message(FLX_DATADDDEBUG,"FlxImagePattenObject::draw","Drawing "+flx_convert_to_string(d_width)+"x"+flx_convert_to_string(d_height)+" image pattern '"+d_name+"' at ("+flx_convert_to_string(flx_pen->screen_x())+","+flx_convert_to_string(flx_pen->screen_y())+")");
  if(d_alpha_bitmap) draw_trans_sprite(flx_cur_buffer,d_alpha_bitmap,flx_pen->x(),flx_pen->y());
}

/*****************************************************************************/

bool NewImageObject(string *name,string *image_file){
  string cur_function="New"+flx_cur_script_command;
  FlxGraphicsObject *new_object;
  
  if(flx_cur_script_command=="ImageObject"){
    new_object=new FlxImageObject(*name,image_file);
  } else if(flx_cur_script_command=="ImagePatternObject"){
    new_object=new FlxImagePatternObject(*name,image_file);
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"NewImageObject called via unknown name "+flx_cur_script_command);  
    return false;
  }
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new "+flx_cur_script_command+" '"+*name+"'");
  flx_add_scalar_source(new_object,image_file);
  flx_process_dependencies(new_object);
  return true;

} /* NewImageObject */

/*****************************************************************************/

void flx_image_objects_init(void){

  flx_add_command("ImageObject",NewImageObject);
  flx_add_command("ImagePatternObject",NewImageObject);
  set_alpha_blender();

} /* flx_image_objects_init */

/*****************************************************************************/

