//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxgraphics\line_objects.h"
#include "flxgraphics\graphics_events.h"
#include <flxbase.h>
#include <cmath>
#include <linkflx.h>

/*****************************************************************************/

void polygon_line(int start_x,int start_y,int end_x,int end_y, int line_width,int color){
  /* We draw lines as polygons that enclose the area covered by the
		line; we do this because drawing thick lines
		incrementally doesn't always give full coverage */
	int delta_x, delta_y;
	double length, cos_offset, sin_offset;
	int vertices[8];

	/* here we compute the cosine and sine of an angle 90 degrees
		clockwise from the angle of the line */
	delta_x=end_x-start_x;
	delta_y=end_y-start_y;
	length=sqrt(float(delta_x*delta_x+delta_y*delta_y));
	cos_offset=delta_y/length;
	sin_offset=-1*delta_x/length;

	vertices[0]=int(start_x+cos_offset*floor(double(line_width)/-2));
	vertices[1]=int(start_y+sin_offset*floor(double(line_width)/-2));
	vertices[2]=int(start_x+cos_offset*floor(double(line_width)/2));
	vertices[3]=int(start_y+sin_offset*floor(double(line_width)/2));
	vertices[4]=int(end_x+cos_offset*floor(double(line_width)/2));
	vertices[5]=int(end_y+sin_offset*floor(double(line_width)/2));
	vertices[6]=int(end_x+cos_offset*floor(double(line_width)/-2));
	vertices[7]=int(end_y+sin_offset*floor(double(line_width)/-2));
	polygon(flx_cur_buffer,4,vertices,color);

} /* polygon_line */

/*****************************************************************************/

void FlxLineObject::draw(void){
	string cur_function="FlxLineObject::draw";

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Drawing line '"+d_name+"' from ("+flx_convert_to_string(d_start->x())+","+flx_convert_to_string(d_start->y())+") to ("+flx_convert_to_string(d_end->x())+","+flx_convert_to_string(d_end->y())+")");
	polygon_line(d_start->x(),d_start->y(),d_end->x(),d_end->y(),*d_line_width,d_color->color_code());

} /* FlxLineObject::draw */

/*****************************************************************************/

bool NewLineObject(string *name,FlxPosition *start,FlxPosition *end){
  string cur_function="NewLineObject";
  FlxLineObject *new_object;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new FlxLineObject '"+*name+"'");
  new_object=new FlxLineObject(*name,start,end);
  flx_add_object_source(new_object,start);
  flx_add_object_source(new_object,end);
  flx_process_dependencies(new_object);
  return true;

} /* NewLineObject */

/*****************************************************************************/

void FlxVectorObject::draw(void){
	string cur_function="FlxVectorObject::draw";
  int start_x, start_y, end_x, end_y;
	float radian_angle;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Drawing vector '"+d_name+"' with angle "+flx_convert_to_string(*d_angle)+" and length "+flx_convert_to_string(*d_length)+" at ("+flx_convert_to_string(flx_pen->screen_x())+","+flx_convert_to_string(flx_pen->screen_y())+")");
	/* compute the start and endpoints of the vector */
	radian_angle=*d_angle*3.1415926/180;
	start_x=flx_pen->x();
	end_x=int(start_x+cos(radian_angle)*(*d_length));
	start_y=flx_pen->y();
	end_y=int(start_y+sin(radian_angle)*(*d_length));
	polygon_line(start_x,start_y,end_x,end_y,*d_line_width,d_color->color_code());

} /* FlxVectorObject::draw */

/*****************************************************************************/

bool NewVectorObject(string *name,long *angle,long *length){
  string cur_function="NewVectorObject";
  FlxVectorObject *new_object;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new FlxVectorObject '"+*name+"'");
  new_object=new FlxVectorObject(*name,angle,length);
  flx_add_scalar_source(new_object,angle);
  flx_add_scalar_source(new_object,length);
  flx_process_dependencies(new_object);
  return true;

} /* NewVectorObject */

/*****************************************************************************/

void flx_line_objects_init(void){

  flx_add_command("LineObject",NewLineObject);
  flx_add_command("VectorObject",NewVectorObject);

} /* flx_line_objects_init */

/*****************************************************************************/
