//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxgraphics\positions.h"
#include "flxgraphics\graphics_objects.h"
#include <linkflx.h>

FlxLength *flx_undefined_length;

FLX_LINKAGE FlxPenLocation *flx_pen;
FLX_LINKAGE int flx_cur_buffer_offset_x, flx_cur_buffer_offset_y;

/*****************************************************************************/

FLX_LINKAGE FlxLength *flx_length(long length,int length_type){
  FlxLength *lop;
  string name;
  string cur_function="flx_length";

  name="FlxLength:"+flx_unique_name();
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating object of type FlxLength named '"+name+"'");
  lop=new FlxLength(name);
  lop->set_value(length);
  lop->set_length_type(length_type);
  return lop;
}

/*****************************************************************************/

long FlxLength::value(int dimension){
  string cur_function="FlxLength::value";
  FlxGraphicsObject *reference_object;
  int max;

  if(d_value==NULL){
    return FLX_LENGTH_UNDEFINED;
  } else {
    if(d_length_type==FLX_LENGTH_ABSOLUTE){
      if(dimension==FLX_LENGTH_X || dimension==FLX_LENGTH_Y){
	return *d_value;
      } else {
	flx_data->write_message(FLX_DATAERROR,cur_function,"Bad dimension code");
	return 0;
      }
    } else if(d_length_type==FLX_LENGTH_PERCENTAGE){
      // We pop the most recent reference object off the stack before
      // calling x_size or y_size, so that recursive calls to this
      // function will use the correct reference object.
      if(dimension==FLX_LENGTH_X){
       	reference_object=flx_reference_graphics_object_stack.pop();
	max=reference_object->x_size();
	flx_reference_graphics_object_stack.push(reference_object);
	return (*d_value)*max/100;
      } else if(dimension==FLX_LENGTH_Y){
	reference_object=flx_reference_graphics_object_stack.pop();
	max=reference_object->y_size();
	flx_reference_graphics_object_stack.push(reference_object);
	return (*d_value)*max/100;
      } else {
	flx_data->write_message(FLX_DATAERROR,cur_function,"Bad dimension code");
	return 0;
      }
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Bad length type code");
      return 0;
    }
  }
}

/*****************************************************************************/

bool flx_type_convert(const string &s,FlxLength *&lp){
  string cur_function="TypeConvert";
  bool err_flag;
  FlxLength *old_lp;
  string clean_s;
  long length;
  int length_type=FLX_LENGTH_ABSOLUTE;
  FlxScalarObject<long> *lop;
  string name;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converting '"+s+"' to a length");
  if(s.size() && s[0]=='$'){ // we have a variable name
    clean_s=s.substr(1); // strip off the leading $
    old_lp=lp;
    lp=flx_get_object_by_name<FlxLength>(clean_s);
    if(lp){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a variable");
      return true;
    } else {
      // as a special case, we allow an implicit conversion from an integer
      // variable
      lop=flx_get_object_by_name<FlxScalarObject<long> >(clean_s);
      if(lop){
	if(lp){
	  lp->set_value(lop->value());
	  lp->set_length_type(FLX_LENGTH_ABSOLUTE);
	} else {
	  name=flx_unique_name();
	  lp=new FlxLength(name);
	  lp->set_value(lop->value());
	  lp->set_length_type(FLX_LENGTH_ABSOLUTE);
	  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating new length object named '"+name+"'");
	}
	flx_add_object_source(lp,lop);
	flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted from an integer");
	return true;
      } else {
	flx_data->write_message(FLX_DATAERROR,cur_function,"There is no length variable named '"+clean_s+"'");
	lp=old_lp;
	return false;
      }
    }
  } else { // we have a literal value
    // try to interpret as an integer value (absolute or percentage)
    if(s[s.size()-1]=='%'){
      length_type=FLX_LENGTH_PERCENTAGE;
      clean_s=s.substr(0,s.size()-1);
    } else {
      length_type=FLX_LENGTH_ABSOLUTE;
      clean_s=s;
    }
    length=flx_string_to_long(clean_s,&err_flag);
    if(err_flag){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Can't convert '"+s+"' to a length");
      return false;
    }   
    if(lp){
      lp->set_value(length);
      lp->set_length_type(length_type);
    } else {
      name=flx_unique_name();
      lp=new FlxLength(name);
      lp->set_value(length);
      lp->set_length_type(length_type);
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating new length object named '"+name+"'");  
    }
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a literal value");
    return true;
  }
}
/*****************************************************************************/

bool FlxPosition::update(void){
  string cur_function="FlxPosition::update";
  FlxPosition *pp=NULL;
  
  if(d_source_string){
    if(flx_do_object_convert(*d_source_string,pp,"FlxPosition")){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Updating FlxPosition by converting from string '"+*d_source_string+"'");
      d_x_pos=pp->d_x_pos;
      d_y_pos=pp->d_y_pos;
      return true;
    } else {
      return false;
    }
  } else {
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Nothing to update");
    return true;
  }

} /* FlxPosition::update */

/*****************************************************************************/

bool flx_type_convert(const string &s,FlxPosition *&pp){

  return flx_object_convert_with_implicit<FlxPosition>(s,pp,"FlxPosition");
}

/*****************************************************************************/

bool DefinePosition(string *label,FlxLength *x_pos,FlxLength *y_pos){
  string cur_function="DefinePosition";
  FlxPosition *new_position;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Defining position '"+*label+"'");
  new_position=new FlxPosition(*label);
  new_position->set_x(x_pos);
  new_position->set_y(y_pos);
  flx_add_object_source(new_position,x_pos);
  flx_add_object_source(new_position,y_pos);
  return true;

} /* DefinePosition */

/*****************************************************************************/

void flx_positions_init(void){
  static FlxPenLocation pen_location;

  flx_undefined_length=new FlxLength("undefined_length");
  flx_undefined_length->set_value(static_cast<long *>(NULL));
  flx_undefined_length->set_length_type(FLX_LENGTH_ABSOLUTE);
  
  flx_add_command("DefinePosition",DefinePosition);

  flx_pen=&pen_location;
  flx_pen->reset();
  flx_cur_buffer_offset_x=flx_cur_buffer_offset_y=0;

} /* flx_positions_init */

/*****************************************************************************/
