//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGUI_DIALOG_EVENTS
#define FLXGUI_DIALOG_EVENTS

#include <flxbase.h>
#include "flxgui\dialog_objects.h"

/*****************************************************************************/

class FLX_LINKAGE FlxDialogEvent : public FlxEvent {
  FlxLinkedList<FlxDialogObject *> d_object_list;
  /* We need to store an array of DIALOG objects, but we don't want to make
	every library using the dialog routines include the allegro headers. So,
	we store it as a void *, and then cast it to a DIALOG * within the functions
	that need to manipulate it. */
  void *d_dialog_array;
  FlxDialogObject **d_dialog_owners;
  /* this holds the index of the dialog element that should be give focus
	when the dialog is displayed */
  int d_focus_element;
  /* this holds the name of the object that was selected/clicked/etc. to make
	the dialog close */
  string d_exit_object;
public:
  FlxDialogEvent(string name) : FlxEvent(name), d_dialog_array(NULL), d_dialog_owners(NULL), d_focus_element(-1) {}
  FLX_LINKAGE ~FlxDialogEvent(void);
  void add_object(FlxDialogObject *object){ d_object_list.insert(object); }
  string exit_object(void){ return d_exit_object; }
  FLX_LINKAGE virtual bool update(void);
  FLX_LINKAGE void execute(void);
};

/*****************************************************************************/

#endif
