//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGUI_DIALOG_OBJECTS
#define FLXGUI_DIALOG_OBJECTS

#include <flxbase.h>
#include <linkflx.h>

#define FLX_DIALOG_OK 1
#define FLX_DIALOG_CANCEL 2

#define FLX_DIALOG_LEFT 1
#define FLX_DIALOG_CENTER 2
#define FLX_DIALOG_RIGHT 3

FLX_LINKAGE extern long *flx_default_dialog_alignment;
FLX_LINKAGE extern long *flx_dialog_alignment_left;
FLX_LINKAGE extern long *flx_dialog_alignment_center;
FLX_LINKAGE extern long *flx_dialog_alignment_right;

/* We have to declare this here so we can declare
   <flx_cur_dialog_object> before we define <FlxDialogObject>, since
   the constructor for the class makes reference to
   <flx_cur_dialog_object> */
class FlxDialogObject;

FLX_LINKAGE extern FlxDialogObject *flx_cur_dialog_object;

/*****************************************************************************/

class FlxDialogObject : public FlxObject {
protected:
  string *d_var_text;
  /* This will actually hold a DIALOG *, but we don't want a module to have to
     #include the Allegro headers in order to use the dialog routines, so
     we store it as a void * instead. */
  void *d_element_ptr;
  // note that width and height is measured in characters, not pixels
  long *d_width;
  long *d_height;
  long *d_alignment;
public:
 FlxDialogObject(const string &name) : FlxObject(name), d_var_text(NULL), d_element_ptr(NULL), d_width(NULL), d_height(NULL), d_alignment(NULL) { 
    this->set_alignment(flx_default_dialog_alignment);
    flx_change_global_setting(&flx_cur_dialog_object,this,"flx_cur_dialog_object");
  }
  virtual ~FlxDialogObject() {}
  virtual int num_elements(void) { return 0; }
  virtual int offer_focus(void) { return -1; }
  void set_var_text(string *var_text){ flx_change_scalar_setting(this,d_var_text,var_text,"FlxDialogObject::d_var_text"); }
  void set_width(long *width){ flx_change_scalar_setting(this,d_width,width,"FlxDialogObject::d_width"); }
  void set_height(long *height){ flx_change_scalar_setting(this,d_height,height,"FlxDialogObject::d_height"); }
  void set_alignment(long *alignment){ flx_change_scalar_setting(this,d_alignment,alignment,"FlxDialogObject::d_alignment");}
  /* For explanation of the void * here, see the comment above. */
  virtual void build(void *d,int &max_element_width,int &cur_y) {}
  FLX_LINKAGE void do_alignment(int max_object_width);
  virtual string exit_object(void){ return d_name; }
  virtual void update_value(int return_status){}
};

/*****************************************************************************/

FLX_LINKAGE extern bool flx_type_convert(const string &,FlxDialogObject *&);

#endif
