//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGUI_DIALOG_TEXT
#define FLXGUI_DIALOG_TEXT

#include <string>
#include "flxgui\dialog_objects.h"

using namespace std;

/*****************************************************************************/

class FLX_LINKAGE FlxDialogText : public FlxDialogObject {
 protected:
  string *d_text;
 public:
 FlxDialogText(const string &name) : FlxDialogObject(name), d_text(NULL) {}
  ~FlxDialogText(){}
  void set_text(string *text){ flx_change_scalar_setting(this,d_text,text,"FlxDialogText::d_text"); }
  int num_elements(void){ return 1; }
  FLX_LINKAGE void build(void *d,int &max_element_width,int &cur_y);
};

/*****************************************************************************/

class FLX_LINKAGE FlxDialogEdit : public FlxDialogText {
	char *d_editable_text;
 public:
 FlxDialogEdit(const string &name) : FlxDialogText(name), d_editable_text(NULL) {}
  FLX_LINKAGE ~FlxDialogEdit();
  int num_elements(void){ return 2; }
  FLX_LINKAGE void build(void *d,int &max_element_width,int &cur_y);
  int offer_focus(void){ return 1; }
  FLX_LINKAGE void update_value(int return_status);
};

/*****************************************************************************/

#endif
