//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include <allegro.h>
#include <flxbase.h>
#include <linkflx.h>
#include "flxgui\dialog_events.h"
#include "flxgui\dialog_text.h"
#include "flxgui\dialog_buttons.h"

/*****************************************************************************/

FLX_LINKAGE int flx_do_alert_dialog(const string &message,const string &button1_text,const string &button2_text){
	FlxDialogEvent *dep;
	FlxDialogText *dtp;
	FlxDialogButtonGroup *dbgp;
	/* We need a non-const variable in order to create a FlxObject with
	   that variable as its value */
	string my_message=message;
	string response;

	flx_begin_scope("flx_alert_dialog");

	flx_create_scalar_object("ALERTDIALOGMESSAGE",&my_message);
	flx_create_scalar_object("ALERTDIALOGRESPONSE",&response);					 
	// create the dialog box
	dep=new FlxDialogEvent("ALERTDIALOG");

	// add the text of the message to the dialog
	dtp=new FlxDialogText("ALERTDIALOGTEXT");
	dtp->set_text(const_cast<string *>(&my_message));
	dep->add_object(dtp);

	// add the button(s) to the dialog
	dbgp=new FlxDialogButtonGroup("ALERTDIALOGBUTTONS");
	dbgp->set_var_text(&response);
	dbgp->set_type(FLX_DIALOG_BUTTON);
	dbgp->set_group_id(1);
	dbgp->add_button(const_cast<string *>(&button1_text));
	// if text is provided for a second button, create one
	if(button2_text!=""){
		dbgp->add_button(const_cast<string *>(&button2_text));
	}
	dbgp->set_alignment(flx_dialog_alignment_center);
	dep->add_object(dbgp);

	// display the dialog
	dep->update();
	dep->execute();

	flx_delete_scope("flx_alert_dialog");

	if(response==button1_text){
		return 1;
	} else if(response==button2_text){
		return 2;
	} else {
		// I think this could happen if the user presses escape
		return 0;
	}

} /* flx_do_alert_dialog */

/*****************************************************************************/

/* IF WE USE THE REGULAR DIALOG ROUTINES FOR ERROR MESSAGES, THEN ANY ERRORS
	IN THE DIALOG ROUTINES THEMSELVES COULD SET UP AN INFINITE LOOP. TO AVOID
	THAT PROBLEM, WE USE THE STOCK ALLEGRO ALERT DIALOG FOR ERROR MESSAGES. */

void do_error_message(int level,const string &message,const string &source){

	alert(message.c_str(),NULL,NULL,"OK",NULL,'\n',0);

} /* do_error_message */

/*****************************************************************************/

void flx_dialog_alerts_init(void){

  flx_data->set_handler(FLX_DATAERROR,do_error_message);

} /* flx_dialog_alerts_init */

/*****************************************************************************/
