//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
//LIC//

#include <allegro.h>
#include <flxbase.h>
#include "flxgui\dialog_bitmaps.h"
#include "flxgui\bitmap_fonts.h"

/*****************************************************************************/
/* We use an update function here, rather than doing everything with
	the build function, for the case where a dialog is used within
	a trial event with a bitmap image that stays the same for each
	trial. In that case, we want to load the image once, when the
	dialog bitmap object is created, rather than re-loading it at
	the beginning of each trial. This is the same approach that is
	used for image objects in the graphics module. */
FLX_LINKAGE bool FlxDialogBitmap::update(void){
	string cur_function="FlxDialogBitmap::update";
	string expanded_bitmap_file;

	expanded_bitmap_file=flx_expand_filename(*d_bitmap_file);
	if(expanded_bitmap_file.empty()){
		flx_data->write_message(FLX_DATAERROR,cur_function,"Can't find image file '"+*d_bitmap_file+"'");
		return false;
	} else {
	  if(d_bitmap) destroy_bitmap(static_cast<BITMAP *>(d_bitmap));
	  d_bitmap=load_bitmap(expanded_bitmap_file.c_str(),NULL);
		if(!d_bitmap){
			flx_data->write_message(FLX_DATAERROR,cur_function,"Can't load image for '"+d_name+"' from '"+*d_bitmap_file+"'");
			return false;
		} else {
		  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Loaded image for '"+d_name+"' from '"+*d_bitmap_file+"'");
			return true;
		}
	}

} /* FlxDialogBitmap::update */

/*****************************************************************************/

FLX_LINKAGE void FlxDialogBitmap::build(void *d,int &max_object_width,int &cur_y){
	string cur_function="FlxDialogBitmap::build";
	DIALOG *dlg=static_cast<DIALOG *>(d);

	// store a pointer to the first element corresponding to this item
	d_element_ptr=d;

	// AGUP doesn't provide a proc for bitmaps, since they don't really depend on the theme 
	dlg->proc=d_bitmap_proc;
	dlg->x=0;
	dlg->y=cur_y;
	dlg->flags=0;
	dlg->dp=d_bitmap;
	// set the size of the dialog object
	if(d_width==NULL){
		dlg->w=static_cast<BITMAP *>(d_bitmap)->w;
	} else {
		dlg->w=*d_width*flx_gui_font_width;
	}
	if(d_height==NULL){
		dlg->h=static_cast<BITMAP *>(d_bitmap)->h;
	} else {
		dlg->h=*d_height*flx_gui_font_height;
	}
	// update parameters relating to the size of the overall dialog
	max_object_width=(dlg->w>max_object_width ? dlg->w : max_object_width);
	cur_y+=dlg->h;
		
} /* FlxDialogBitmap::build */

/*****************************************************************************/

bool NewDialogBitmap(string *name,string *bitmap_file){
  string cur_function="NewDialogBitmap";
  FlxDialogBitmap *dbp;
  
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new DialogBitmap '"+*name+"'");
  dbp=new FlxDialogBitmap(*name);
  dbp->set_bitmap_file(bitmap_file);
  flx_cur_dialog_object=dbp;
  flx_add_scalar_source(flx_cur_dialog_object,bitmap_file);
  flx_process_dependencies(flx_cur_dialog_object);
  return true;

} /* NewDialogBitmap */

/*****************************************************************************/

void flx_dialog_bitmaps_init(void){

  flx_add_command("DialogBitmap",NewDialogBitmap);

} /* flx_dialog_bitmaps_init */

/*****************************************************************************/
