//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
//LIC//

#include <allegro.h>
#include <flxbase.h>
#include <agup.h>
#include "flxgui\dialog_buttons.h"
#include "flxgui\bitmap_fonts.h"

/*****************************************************************************/

FLX_LINKAGE int FlxDialogButtonGroup::num_elements(void) { 
	int i=0;

	while(d_button_list.item()){
		i++;
		d_button_list.advance();
	}
	d_button_list.rewind();
	return i; 

} /* FlxDialogButtonGroup::num_elements */

FLX_LINKAGE void FlxDialogButtonGroup::build(void *d,int &max_object_width,int &cur_y){
	int i, cur_x;
	DIALOG *dlg=static_cast<DIALOG *>(d);
	string **button_text;

	// store a pointer to the first element corresponding to this item
	d_element_ptr=d;

	cur_x=0;
	i=0;
	while((button_text=d_button_list.item())){
		if(d_type==FLX_DIALOG_BUTTON){
			dlg->proc=d_agup_button_proc;
			dlg->flags=D_EXIT;
			// pressing enter is equivalent to selecting OK
			// NOTE: This may need to be different for Linux
			if(**button_text=="OK") dlg->key='\r';
		} else if(d_type==FLX_DIALOG_RADIO){
			dlg->proc=d_agup_radio_proc;
			dlg->d1=d_group; // the button group this element belongs to
			dlg->d2=0; // use circular buttons
			dlg->flags=(i==0 ? D_SELECTED : 0); /* first button in the set is
												initially selected */
		}
		dlg->dp=const_cast<char *>((*button_text)->c_str());
		dlg->x=cur_x;
		dlg->y=cur_y;
		// set the size of the dialog object
		if(d_width==NULL){
			dlg->w=text_length(font,(*button_text)->c_str())+flx_gui_font_width;
		} else {
			dlg->w=*d_width*flx_gui_font_width;
		}
		if(d_height==NULL){
		  dlg->h=static_cast<int>(flx_gui_font_height*1.2);
		} else {
			dlg->h=*d_height*flx_gui_font_height;
		}
		cur_x+=dlg->w+flx_gui_font_width;
		dlg++;
		i++;
		d_button_list.advance();
	}
	d_button_list.rewind();

	// update parameters relating to the size of the overall dialog
	cur_x-=flx_gui_font_width;
	max_object_width=(cur_x>max_object_width ? cur_x : max_object_width);
	cur_y+=(dlg-1)->h;

} /* FlxDialogButtonGroup::build */

/*****************************************************************************/

string FlxDialogButtonGroup::exit_object(void){
	DIALOG *dlg;
	string selected;

	dlg=static_cast<DIALOG *>(d_element_ptr);
	/* step through each button in the list and find out which one is
		selected */
	while(d_button_list.item()){
		/* When a regular button is clicked to close the dialog, Allegro
			does not set its flags field to D_SELECTED. So, for those
			buttons we assume that the one that was clicked was the one
			that had input focus at the time the box was closed. */
		if((dlg->flags & D_SELECTED) || (dlg->proc==d_agup_button_proc && (dlg->flags & D_GOTFOCUS))){
			selected=static_cast<char *>(dlg->dp);
			break;
		}
		dlg++;
		d_button_list.advance();
	}
	d_button_list.rewind();
	return selected;

} /* FlxDialogButtonGroup::exit_object */

/*****************************************************************************/

FLX_LINKAGE void FlxDialogButtonGroup::update_value(int return_status){
  DIALOG *dlg;
  int i;


	/* if the return status was okay, or if these are regular buttons (not radios) */
	if(return_status==FLX_DIALOG_OK || d_type==FLX_DIALOG_BUTTON){
		*d_var_text=exit_object();
	}

	/* for radio buttons, reset the selection so that the first
	   button is selected */
	if(d_type==FLX_DIALOG_RADIO){
	  i=0;
	  dlg=static_cast<DIALOG *>(d_element_ptr);
	  while(d_button_list.item()){
	    dlg->flags=(i==0 ? D_SELECTED : 0);
	    i++;
	    dlg++;
	    d_button_list.advance();
	  }
	  d_button_list.rewind();
	}

} /* FlxDialogButtonGroup::update_value */

/*****************************************************************************/

bool NewDialogButtonGroup(string *name,string *var_name){
	string cur_function="New"+flx_cur_script_command;
	int type;
	static long num_button_groups=0;
	FlxScalarObject<string> *sop;
	FlxDialogButtonGroup *dbgp;

	flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new "+flx_cur_script_command+"'"+*name+"'");
	if(flx_cur_script_command=="DialogButtonGroup"){
		type=FLX_DIALOG_BUTTON;
	} else if(flx_cur_script_command=="DialogRadioGroup"){
		type=FLX_DIALOG_RADIO;
	}  else {
	  flx_data->write_message(FLX_DATAERROR,cur_function,"NewDialogButtonGroup called via unknown name "+flx_cur_script_command);  
	  return false;
	}

	/* <num_button_groups> is used to keep track of how
	   many groups of buttons we have. It only matters for
	   radio buttons, where within each group, only one
	   button can be selected at a time */
	num_button_groups++;

	sop=new FlxScalarObject<string>(*var_name);
	sop->set_value("");
	dbgp=new FlxDialogButtonGroup(*name);
	dbgp->set_var_text(sop->value());
	dbgp->set_type(type);
	dbgp->set_group_id(num_button_groups);
	return true;

} /* NewDialogButtonGroup */

/*****************************************************************************/

bool DialogButton(string *text){
	string cur_function="DialogButton";
	FlxDialogButtonGroup *dbp;

	if(flx_cur_dialog_object==NULL){
		flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": A DialogButtonGroup object must be selected before you can create new buttons");
		return false;
	} else if((dbp=dynamic_cast<FlxDialogButtonGroup *>(flx_cur_dialog_object))){
		flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new button");
		dbp->add_button(text);
		flx_add_scalar_source(flx_cur_dialog_object,text);
		return true;
	} else {
		flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_dialog_object).name())+" can't have buttons");
		return false;
	}

} /* DialogButton */

/*****************************************************************************/

void flx_dialog_buttons_init(void){

  flx_add_command("DialogButtonGroup",NewDialogButtonGroup);
  flx_add_command("DialogRadioGroup",NewDialogButtonGroup);
  flx_add_command("DialogButton",DialogButton);

} /* flx_dialog_buttons_init */

/*****************************************************************************/
