//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
//LIC//

#include <allegro.h>
#include <flxbase.h>
#include <agup.h>
#include "flxgui\dialog_text.h"
#include "flxgui\bitmap_fonts.h"

#define FLX_DEFAULT_EDIT_WIDTH 8

/*****************************************************************************/

FLX_LINKAGE void FlxDialogText::build(void *d,int &max_object_width,int &cur_y){
	DIALOG *dlg=static_cast<DIALOG *>(d);

	// store a pointer to the first element corresponding to this item
	d_element_ptr=d;

	// define the properties of the text element
	dlg->proc=d_agup_text_proc;
	dlg->x=0;
	dlg->y=cur_y;
	// set the size of the dialog object
	if(d_width==NULL){
		dlg->w=text_length(font,d_text->c_str());
	} else {
		dlg->w=*d_width*flx_gui_font_width;
	}
	if(d_height==NULL){
		dlg->h=flx_gui_font_height;
	} else {
		dlg->h=*d_height*flx_gui_font_height;
	}
	dlg->dp=const_cast<char *>(d_text->c_str());

	// update parameters relating to the size of the overall dialog
	max_object_width=(dlg->w>max_object_width ? dlg->w : max_object_width);
	cur_y+=dlg->h;

} /* FlxDialogText::build */

/*****************************************************************************/

bool NewDialogText(string *name,string *text){
	string cur_function="NewDialogText";
	FlxDialogText *dtp;

	flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new DialogText '"+*name+"'");
	dtp=new FlxDialogText(*name);
	dtp->set_text(text);
	return true;

} /* NewDialogText */

/*****************************************************************************/

FLX_LINKAGE FlxDialogEdit::~FlxDialogEdit(void){

	/* this frees the memory allocated for the editable text */
	if(d_editable_text) delete d_editable_text;

} /* FlxDialogEdit::~FlxDialogEdit */

/*****************************************************************************/

FLX_LINKAGE void FlxDialogEdit::build(void *d,int &max_object_width,int &cur_y){
	string cur_function="FlxDialogEdit::build_item";
	DIALOG *dlg=static_cast<DIALOG *>(d);
	long *wp, *hp;

	/* We use the code from FlxDialogText to create the prompt. We set the
		width and height to NULL before doing this because we want those
		parameters to apply to the editable text, not the prompt. With 
		width and height set to NULL, the prompt will be the default size. */
	wp=d_width;
	hp=d_height;
	d_width=d_height=NULL;
	FlxDialogText::build(d,max_object_width,cur_y);
	d_width=wp;
	d_height=hp;

	// advance to the next element in the array
	dlg++;

	// define the properties of the editable element
	dlg->proc=d_agup_edit_proc;
	/* if the prompt is empty, then don't insert space between the prompt
		and the editable text */
	if((dlg-1)->w) dlg->x=(dlg-1)->w+flx_gui_font_width;
	dlg->y=(dlg-1)->y;
	// set the size of the dialog object
	if(d_width==NULL){
		dlg->w=flx_gui_font_width*FLX_DEFAULT_EDIT_WIDTH;
	} else {
		dlg->w=*d_width*flx_gui_font_width;
	}
	if(d_height==NULL){
		dlg->h=flx_gui_font_height;
	} else {
		dlg->h=*d_height*flx_gui_font_height;
	}
	dlg->d1=(d_width ? *d_width : FLX_DEFAULT_EDIT_WIDTH); // the max number of characters the box will accept
	if(d_editable_text) delete d_editable_text;
	dlg->dp=d_editable_text=new char[dlg->d1+1]; // allocate memory for the editable text
	static_cast<char *>(dlg->dp)[0]='\0'; /* the editable text should initially
											be empty */

	// update parameters relating to the size of the overall dialog
	max_object_width=((dlg-1)->w+flx_gui_font_width+dlg->w>max_object_width ? (dlg-1)->w+flx_gui_font_width+dlg->w : max_object_width);
	/* set the height of the entire object to be the height of the editable text
		rather than the height of the prompt */
	cur_y+=(-1*(dlg-1)->h+dlg->h);

} /* FlxDialogEdit::build */

/*****************************************************************************/

FLX_LINKAGE void FlxDialogEdit::update_value(int return_status){ 

	if((return_status=FLX_DIALOG_OK)) *d_var_text=static_cast<char *>(static_cast<DIALOG *>(d_element_ptr)[1].dp);
	// reset the editable text to be empty
	static_cast<char *>(static_cast<DIALOG *>(d_element_ptr)[1].dp)[0]='\0';

} /* FlxDialogEdit::update_value */

/*****************************************************************************/

bool NewDialogEdit(string *name,string *var_name,string *prompt){
	string cur_function="NewDialogEdit";
	FlxScalarObject<string> *sop;
	FlxDialogEdit *dep;

	flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new DialogEdit object '"+*name+"'");
	if(!(sop=flx_get_object_by_name<FlxScalarObject<string> >(*var_name))){
	  sop=new FlxScalarObject<string>(*var_name);
	  sop->set_value("");
	}
	dep=new FlxDialogEdit(*name);
	dep->set_var_text(sop->value());
	dep->set_text(prompt);
	return true;

} /* NewDialogEdit */

/*****************************************************************************/

void flx_dialog_text_init(void){

	flx_add_command("DialogText",NewDialogText);
	flx_add_command("DialogEdit",NewDialogEdit,"");

} /* flx_dialog_text_init */

/*****************************************************************************/
