//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <allegro.h>
#include <flxbase.h>

int old_joystick_state=0;
FlxLinkedList<int> buttons_read;
string last_joystick="NA";

/*****************************************************************************/

bool process_joystick_state(void){
	string cur_function="process_joystick_state";
  int i, bit_position, cur_joystick_state;

  if(poll_joystick()){
    return false;
  } else {
    /* basically, we store a button press when a button bit changes
       from 0 to 1 */
    bit_position=1;
    cur_joystick_state=0;
    for(i=0;i<joy[0].num_buttons;i++){
      bit_position*=2;
      if(joy[0].button[i].b!=0){
		cur_joystick_state+=bit_position;
		if((old_joystick_state&bit_position)==0){
			buttons_read.insert(i);
			last_joystick=flx_convert_to_string(i);
			flx_data->write_message(FLX_DATADEBUG,cur_function,"Joystick button "+last_joystick+" pressed");
		}
      }
    }
    old_joystick_state=cur_joystick_state;
    return true;
  }

} /* process_joystick_state */

/*****************************************************************************/

bool clear_joystick_state(void){
  string cur_function="clear_joystick_state";

  flx_data->write_message(FLX_DATAHOOK,cur_function,"Clearing joystick state");
  buttons_read.remove_all();
  old_joystick_state=0;
  return true;

} /* clear_joystick_state */

/*****************************************************************************/

#define BUTTONMATCH_ANY -1

class JoystickCondition : public FlxCondition {
  int d_button_code;
  bool d_triggered;
public:
  JoystickCondition(const string &name,int button_code) : FlxCondition(name), d_button_code(button_code), d_triggered(false) {}
  ~JoystickCondition(void) {}
  bool evaluate(void); 
  void reset(void){ d_triggered=false; }
};

bool JoystickCondition::evaluate(void){
  int *next_button_ptr;
  
  if(d_triggered){
    return false;
  } else {
    // check if there's a matching button stored
    while((next_button_ptr=buttons_read.item())){
      if(d_button_code==BUTTONMATCH_ANY || *next_button_ptr==d_button_code){
		buttons_read.remove();
		d_triggered=true;
		break;
	  }
      buttons_read.advance();
	}
    buttons_read.rewind();    
    return d_triggered;
  }	
}

/*****************************************************************************/

FlxCondition *joystick_condition_parser(const string &keyword,int arg_count,string *arg_array){
  string cur_function="joystick_condition_parser";
  long button_code;
  long *button_code_ptr=&button_code;
  string name;

  if(arg_count!=1){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Bad joystick condition");
    return NULL;
  } else {
    // parse the button specification
    if(arg_array[0]=="any"){	
      button_code=BUTTONMATCH_ANY;
    } else if(!flx_type_convert(arg_array[0],button_code_ptr)){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Joystick button must be either an integer or 'any'");
      return NULL; 
    }
    name=flx_unique_name();
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating new joystick condition named '"+name+"'");
    return new JoystickCondition(name,button_code);
  }

} /* joystick_condition_parser */

/*****************************************************************************/

void flx_joystick_init(void){
  string cur_function="joystick_init";

  flx_create_scalar_object("joystick",&last_joystick);
  flx_add_condition_type("joystick",joystick_condition_parser);
  flx_add_event_hook("clear_joystick_state",clear_joystick_state,FLX_EVENT_HOOK_PRESESSION);
  flx_add_event_hook("clear_joystick_state",clear_joystick_state,FLX_EVENT_HOOK_PRETRIAL);
  flx_add_event_hook("clear_joystick_state",clear_joystick_state,FLX_EVENT_HOOK_POSTTRIAL);
  flx_add_event_hook("process_joystick_state",process_joystick_state,FLX_EVENT_HOOK_WITHINEVENT);

} /* flx_joystick_init */

/*****************************************************************************/
