//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXSOUND_FLX_SOUND_EVENT
#define FLXSOUND_FLX_SOUND_EVENT

#include "flxsound\sound_driver.h"
#include "flxsound\sound_buffer.h"

using namespace std;

class FlxSoundEvent : public FlxEvent {
 protected:
  string *d_file_name;
  FlxSoundBuffer *d_buffer;
  int d_stream;
 public:
 FlxSoundEvent(const string &name,string *file_name) : FlxEvent(name), d_file_name(NULL), d_buffer(new FlxSoundBuffer()), d_stream(0) {
    if(file_name){
      flx_suspend_setting_updates();
      flx_change_scalar_setting(this,d_file_name,file_name,"FlxSoundEvent::d_file_name");
      flx_resume_setting_updates();  
    }
  }
  ~FlxSoundEvent(void){ if(flx_sound_driver->is_valid_stream(d_stream)) flx_sound_driver->close_stream(d_stream); delete d_buffer; }
};

#endif
