//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXSOUND_WAV_FILES
#define FLXSOUND_WAV_FILES

#include <stdint.h>

#include <iostream>
#include <fstream>

using namespace std;

typedef struct Flx_WAV_File_Header_type {
  char d_fileID[4];
  int32_t d_fileSize;
  char d_fileType[4];
} Flx_WAV_File_Header;

typedef struct WAV_Chunk_Header_type {
  char d_chunkID[4];
  int32_t d_chunkSize;
} WAV_Chunk_Header;

typedef struct Flx_WAV_Format_Chunk_type {
  int16_t d_formatTag; 
  int16_t d_channels; 
  int32_t d_samplesPerSec; 
  int32_t d_avgBytesPerSec; 
  int16_t d_blockAlign; 
  int16_t d_bitsPerSample;
} Flx_WAV_Format_Chunk;

class Flx_WAV_File {
  Flx_WAV_File_Header d_file_header;
  WAV_Chunk_Header d_format_header;
  Flx_WAV_Format_Chunk d_format_chunk;
  WAV_Chunk_Header d_data_header;
  char *d_data_chunk;
public:
 Flx_WAV_File(void) : d_data_chunk(NULL) {}
  ~Flx_WAV_File(){ if(d_data_chunk) delete d_data_chunk; }
  bool read(ifstream *input_stream);
  void get_sound_params(int &bits,int &channels,long &rate,long &data_bytes);
  void get_sound_data(char *data);
  void set_sound_params(int bits,int channels,long rate,long data_bytes);
  void set_sound_data(char *data);
  void write(ofstream *output_stream);
};

#endif
