//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <flxbase.h>
#include "flxsound\sound_event.h"
#include "flxsound\wav_files.h"

long *flx_default_bits;
long *flx_default_channels;
long *flx_default_rate;
long *flx_default_buffer_size;

/*****************************************************************************/

class FlxRecordSoundEvent : public FlxSoundEvent {
public:
  FlxRecordSoundEvent(const string &name,string *file_name);
  ~FlxRecordSoundEvent(void){}
  void execute(void);
};

/*****************************************************************************/

FlxRecordSoundEvent::FlxRecordSoundEvent(const string &name,string *file_name) : FlxSoundEvent(name,file_name){
  string cur_function="FlxRecordSoundEvent::FlxRecordSoundEvent";

  d_buffer->set_params(*flx_default_bits,*flx_default_channels,*flx_default_rate,*flx_default_buffer_size,FLX_INPUT_STREAM);
  d_buffer->allocate_data();
  if(!(d_stream=flx_sound_driver->open_stream(d_buffer))){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Can't open sound input stream");
  }

} /* FlxRecordSoundEvent::FlxRecordSoundEvent */

/*****************************************************************************/

void FlxRecordSoundEvent::execute(void){
  string cur_function="FlxRecordSoundEvent::execute";
  ofstream *output_stream;
  Flx_WAV_File *wav_file;
  long bytes_recorded;

  if(flx_sound_driver->is_valid_stream(d_stream) && flx_sound_driver->is_active_stream(d_stream)){
    // determine how much data we've recorded
    bytes_recorded=d_buffer->cur_pos();
    // stop the recording
    flx_sound_driver->stop_stream(d_stream);
    // save out the sound data
    if(d_file_name){
      output_stream=new ofstream(d_file_name->c_str(),ios::binary);
      if(!*output_stream){
	flx_data->write_message(FLX_DATAERROR,cur_function,"Can't open file '"+*d_file_name+"' for writing sound data"); 
      } else {
	flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Writing "+flx_convert_to_string(bytes_recorded)+" bytes of sound data to '"+*d_file_name+"'");     
	wav_file=new Flx_WAV_File();
	wav_file->set_sound_params(d_buffer->bits(),d_buffer->channels(),d_buffer->rate(),bytes_recorded);
	wav_file->set_sound_data(d_buffer->data());
	wav_file->write(output_stream);
	delete wav_file;
	output_stream->close();
      }
      delete output_stream;
    }
  } else { 
    // start the recording
    if(!flx_sound_driver->start_stream(d_stream)){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Can't start audio stream");
    } 
  }

  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
  this->do_generic_event_processing();

} /* FlxRecordSoundEvent::execute */

/*****************************************************************************/

bool NewRecordSoundEvent(string *name,string *file_name){
  string cur_function="NewRecordSoundEvent";
  FlxRecordSoundEvent *rse;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new RecordSoundEvent '"+*name+"'");
  rse=new FlxRecordSoundEvent(*name,file_name);
  return true;

} /* NewRecordSoundEvent */

/*****************************************************************************/

bool SetRecordBits(long *bits){
  string cur_function="SetRecordBits";
 
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default record bits");
  flx_change_global_setting(&flx_default_bits,bits,"flx_default_bits");
  return true;

} /* SetRecordBits */

/*****************************************************************************/

bool SetRecordChannels(long *channels){
  string cur_function="SetRecordChannels";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default record channels");
  flx_change_global_setting(&flx_default_channels,channels,"flx_default_channels");
  return true;

} /* SetRecordChannels */

/*****************************************************************************/

bool SetRecordRate(long *rate){
  string cur_function="SetRecordRate";
 
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default record rate");
  flx_change_global_setting(&flx_default_rate,rate,"flx_default_rate");
  return true;

} /* SetRecordRate */

/*****************************************************************************/

bool SetRecordBufferSize(long *buffer_size){
  string cur_function="SetRecordBufferSize";
 
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default record buffer size");
  flx_change_global_setting(&flx_default_buffer_size,buffer_size,"flx_default_buffer_size");
  return true;

} /* SetRecordBufferSize */

/*****************************************************************************/

void flx_record_sound_init(void){
  string cur_function="flx_record_sound_init";

  flx_add_command("RecordSoundEvent",NewRecordSoundEvent);
  flx_add_command("RecordBits",SetRecordBits);
  flx_add_command("RecordChannels",SetRecordChannels);
  flx_add_command("RecordRate",SetRecordRate);

  flx_default_bits=flx_long(16);
  flx_default_channels=flx_long(1);
  flx_default_rate=flx_long(22050);
  flx_default_buffer_size=flx_long(500000);

} /* flx_record_sound_init */

/*****************************************************************************/
