//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <flxbase.h>

/*****************************************************************************/

class VoiceKeyCondition : public FlxCondition {
  static float s_baseline_sound_level;
  static float s_high_background;
  static bool s_input_detected;
  bool d_triggered;
public:
  VoiceKeyCondition(const string &name) : FlxCondition(name), d_triggered(false) {}
  ~VoiceKeyCondition() {}
  static bool process_sound_level(void);
  bool evaluate(void);
  void reset(void){
    d_triggered=false; 
    s_baseline_sound_level=s_high_background; /* this ensures that the voice key
					       won't immediately trigger if the
					       background sound level is greater
					       than 0 */
    s_input_detected=false;
  }
};

/* this ensures that the voice key won't immediately trigger if the
   background sound level is greater than 0 */
float VoiceKeyCondition::s_high_background=20.0;
float VoiceKeyCondition::s_baseline_sound_level=s_high_background; 
bool VoiceKeyCondition::s_input_detected=false;

/*****************************************************************************/

bool VoiceKeyCondition::process_sound_level(void){
  //float current_level;
  //  FlxSoundBuffer **record_buffer;

  /* Note that this only monitors the sound level on the first
     recording buffer.  In principle FLXLab can support multiple
     recording buffers, though as I am writing this, none of the sound
     drivers implement this. */
  /*if((record_buffer=cur_record_sound_buffers.item()) && (*record_buffer)->status()==FLX_SOUND_RUNNING){
     if((current_level=(*record_buffer)->sound_level())>1/(*flx_voice_key_sensitivity)*s_baseline_sound_level+1){
       s_input_detected=true;
     } else {
       if(current_level>=0.0){
	 s_baseline_sound_level=background_filtering*s_baseline_sound_level+(1-background_filtering)*current_level;
       }
       s_input_detected=false;
     }
     }*/
  return true;
  
} /* VoiceKeyCondition::process_sound_level */

/*****************************************************************************/

bool VoiceKeyCondition::evaluate(void){

  if(!d_triggered && s_input_detected){
    d_triggered=true;
    return true;
  } else {
    return false;
  }

} /* VoiceKeyCondition::evaluate */

/*****************************************************************************/

FlxCondition *voice_key_condition_parser(const string &keyword,int arg_count,string *arg_array){
  string cur_function="voice_key_condition_parser";
  string name;

  if(arg_count!=0){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Bad voice key condition");
    return NULL;
  } else {
    name=flx_unique_name();
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating new voice key condition named '"+name+"'");
    return new VoiceKeyCondition(name);
  }

} /* voice_key_condition_parser */

/*****************************************************************************/

void flx_voice_key_init(void){
  string cur_function="voice_key_init";

  flx_add_condition_type("voice_key",&voice_key_condition_parser);

} /* flx_voice_key_init */

/*****************************************************************************/
