//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string.h>
#include "flxsound/wav_files.h"

/*****************************************************************************/

void Flx_WAV_File::set_sound_params(int bits,int channels,long rate,long data_bytes){

  /* fill in values for the headers & format chunk */
  memcpy(d_file_header.d_fileID,"RIFF",4);
  d_file_header.d_fileSize=sizeof(d_file_header.d_fileType)+sizeof(d_format_header)+sizeof(d_format_chunk)+sizeof(d_data_header)+data_bytes;
  memcpy(d_file_header.d_fileType,"WAVE",4);
  
  memcpy(d_format_header.d_chunkID,"fmt ",4);
  d_format_header.d_chunkSize=sizeof(d_format_header)+sizeof(d_format_chunk)-sizeof(d_format_header.d_chunkID)-sizeof(d_format_header.d_chunkSize);
  
  d_format_chunk.d_formatTag=1;
  d_format_chunk.d_channels=channels;
  d_format_chunk.d_samplesPerSec=rate;
  d_format_chunk.d_avgBytesPerSec=rate*channels*(bits/8);
  d_format_chunk.d_blockAlign=bits/8;
  d_format_chunk.d_bitsPerSample=bits;
  
  memcpy(d_data_header.d_chunkID,"data",4);
  d_data_header.d_chunkSize=data_bytes;

} /* Flx_WAV_File::set_sound_params */

/*****************************************************************************/

void Flx_WAV_File::set_sound_data(char *data){

  if(d_data_chunk){
    delete d_data_chunk;
  }

  d_data_chunk=new char[d_data_header.d_chunkSize];
  memcpy(d_data_chunk,data,d_data_header.d_chunkSize);

} /* Flx_WAV_File::set_sound_data */

/*****************************************************************************/

void Flx_WAV_File::write(ofstream *output_stream){

  /* write the headers & format chunk to the file */
  output_stream->write(reinterpret_cast<char *>(&d_file_header),sizeof(Flx_WAV_File_Header));
  output_stream->write(reinterpret_cast<char *>(&d_format_header),sizeof(WAV_Chunk_Header));
  output_stream->write(reinterpret_cast<char *>(&d_format_chunk),sizeof(Flx_WAV_Format_Chunk));
  output_stream->write(reinterpret_cast<char *>(&d_data_header),sizeof(WAV_Chunk_Header));
  /* write the data to the file */
  output_stream->write(d_data_chunk,d_data_header.d_chunkSize);
  /* wav file chunks must be word-aligned */
  if(d_data_header.d_chunkSize%2==1){
    output_stream->put(0);
  }

} /* Flx_WAV_File::write */

/*****************************************************************************/

bool Flx_WAV_File::read(ifstream *input_stream){
  WAV_Chunk_Header next_chunk_header;

  /* read the headers & format chunk from the file */
  input_stream->read(reinterpret_cast<char *>(&d_file_header),sizeof(Flx_WAV_File_Header));
  if(strncmp(d_file_header.d_fileID,"RIFF",4) || strncmp(d_file_header.d_fileType,"WAVE",4)){
    // not a WAV file
    return false;
  } else {
    while(input_stream->read(reinterpret_cast<char *>(&next_chunk_header),sizeof(WAV_Chunk_Header)) && !input_stream->fail()){
      if(!strncmp(next_chunk_header.d_chunkID,"fmt ",4)){
	d_format_header=next_chunk_header;
	input_stream->read(reinterpret_cast<char *>(&d_format_chunk),sizeof(Flx_WAV_Format_Chunk));
	if(d_format_chunk.d_formatTag!=1){
	  return false;
	}
      } else if(!strncmp(next_chunk_header.d_chunkID,"data",4)){
	d_data_header=next_chunk_header;
	if(d_data_chunk){
	  delete d_data_chunk;
	}
	d_data_chunk=new char[d_data_header.d_chunkSize];
	input_stream->read(d_data_chunk,d_data_header.d_chunkSize);
      } else { // not a format or data chunk, skip it
	input_stream->ignore(next_chunk_header.d_chunkSize);
      }
    }
  }

  return true;

} /* Flx_WAV_File::read_sound_params */

/*****************************************************************************/

void Flx_WAV_File::get_sound_params(int &bits,int &channels,long &rate,long &data_bytes){

  bits=d_format_chunk.d_bitsPerSample;
  channels=d_format_chunk.d_channels;
  rate=d_format_chunk.d_samplesPerSec;
  data_bytes=d_data_header.d_chunkSize;
  
} /* Flx_WAV_File::get_sound_params */

/*****************************************************************************/


void Flx_WAV_File::get_sound_data(char *data){

  memcpy(data,d_data_chunk,d_data_header.d_chunkSize);

} /* Flx_WAV_File::read_sound_data */

/*****************************************************************************/

