//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXSOUND_SOUND_DRIVER
#define FLXSOUND_SOUND_DRIVER

#include <linkflx.h>

#define FLX_SOUND_DRIVER_RUNNING -1
#define FLX_SOUND_DRIVER_STOPPED -2
#define FLX_SOUND_DRIVER_ERROR -3

/* The virtual functions below are the ones that any sound driver must implement */
class FlxSoundDriver {
protected:
 public:
  FlxSoundDriver(void){}
  virtual ~FlxSoundDriver(void){}
  virtual bool init(void)=0;
  virtual void exit(void)=0;
  virtual int prepare_playback(void)=0;
  virtual bool start_playback(int device_buffer_descriptor,int channels,int bits,long rate,char *,long)=0;
  virtual int update_playback(int)=0;
  virtual void stop_playback(int)=0;
  virtual int prepare_capture(void)=0;
  virtual bool start_capture(int device_buffer_descriptor,int channels,int bits,long rate,char *,long)=0;
  virtual int update_capture(int)=0;
  virtual void stop_capture(int)=0;
};

FLX_LINKAGE extern FlxSoundDriver *flx_sound_driver;

#endif
