//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#define FLX_INCLUDE_MODULE_HEADER
#include <flxbase.h>

extern void flx_fonts_init(void);
extern void flx_text_objects_init(void);
extern void flx_text_functions_init(void);
extern void flx_text_commands_init(void);

extern void font_init_callback(void);
extern void text_object_init_callback(void);

/*****************************************************************************/

/* On the Mac, the initialization function seems to get called before
   global variables are initialized. So, if you try to reference one
   of the globals during the initialization function, it may crash,
   or the value of the global may get re-set when the function 
   finishes loading. To avoid this problem, we initialize our globals here
   instead. */

void text_init_callback(void){
  string cur_function="font_init_callback";

  font_init_callback();
  text_object_init_callback();

} /* text_init_callback */

/*****************************************************************************/

extern "C" {

  FLX_START_MODULE_INIT(text)

  string cur_function="text_module_init";

  flx_data->write_message(FLX_DATAINFO,cur_function,"Initializing text module");

  flx_fonts_init();
  flx_text_objects_init();
  flx_text_functions_init();
  flx_text_commands_init();

  flx_set_module_post_load_callback(text_init_callback);

  FLX_END_MODULE_INIT

}

/*****************************************************************************/





