//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <fstream>
#include <flxgraphics.h>
#include <flxbase.h>
#include "flxtext\text_objects.h"
#include "flxtext\text_functions.h"
#include "flxtext\text_commands.h"

/*****************************************************************************/

bool load_text(const string &file_name,string *&tp){
  string cur_function="load_text";
  string expanded_file_name;
  ifstream *text_file;
  char next_char;
  string text;

  expanded_file_name=flx_expand_filename(file_name);
  if(expanded_file_name.empty()){
	  flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Couldn't find file '"+file_name+"'");
	return false;
  } else {
    text_file=new ifstream(expanded_file_name.c_str());
    if(!*text_file){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Couldn't load text from file '"+file_name+"'");
      return false;
    } else {
      while(text_file->get(next_char)){
	text+=next_char;
      }
      if(tp){
	*tp=text; 
      } else {
	tp=new string(text);
      }
      text_file->close();
      delete(text_file);
      return true;
    }
  }

} /* load_text */

/*****************************************************************************/

class FlxTextFromFile : public FlxScalarFromStringObject<string> {
public:
  FlxTextFromFile(const string &name,string *source_string) : FlxScalarFromStringObject<string>(name,source_string){}
  ~FlxTextFromFile(void){}
  bool update(void){ return load_text(*d_source_string,d_value); }
};

/*****************************************************************************/

bool SetFontFace(string *f){
  string cur_function="SetFontFace";
  FlxTextObject *top;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default font face attribute");
    flx_change_global_setting(&flx_default_text_font,f,"flx_default_text_font");
    return true;
  } else if((top=dynamic_cast<FlxTextObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting font face of '"+top->name()+"'");
    top->set_font(f);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a font face");
    return false;
  }

} /* SetFontFace */

/*****************************************************************************/

bool SetFontSize(long *s){
  string cur_function="SetFontSize";
  FlxTextObject *top;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default font size attribute");
    flx_change_global_setting(&flx_default_text_size,s,"flx_default_text_size");
    return true;
  } else if((top=dynamic_cast<FlxTextObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting font size of '"+top->name()+"'");
    top->set_size(s);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a font size");
    return false;
  }

} /* SetFontSize */

/*****************************************************************************/

bool SetTextJustification(long *tjp){
  string cur_function="SetTextJustification";
  FlxTextBoxObject *tbop;
  
  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default text justification attribute");
    flx_change_global_setting(&flx_default_text_justification,tjp,"flx_default_text_justification");
    return true;
  } else if((tbop=dynamic_cast<FlxTextBoxObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting justification of '"+tbop->name()+"'");
    tbop->set_text_justification(tjp);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a justification");
    return false;
  }

} /* SetTextJustification */

/*****************************************************************************/

bool SetTextBackgroundColor(FlxColor *cp){
  string cur_function="SetTextBackgroundColor";
  FlxTextObject *top;

  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Setting default text background color attribute");
    flx_change_global_setting(&flx_default_text_background_color,cp,"flx_default_text_background_color");
    return true;
  } else if((top=dynamic_cast<FlxTextObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting text background color of '"+top->name()+"'");
    top->set_background_color(cp);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have a text background color");
    return false;
  }

} /* SetTextBackgroundColor */

/*****************************************************************************/

bool SetAntialiased(bool *bp){
  string cur_function="SetAntialiased";
  FlxTextObject *top;
  
  if(flx_cur_graphics_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default antialiasing attribute");
    flx_change_global_setting(&flx_default_antialiasing,bp,"flx_default_antialiasing");
    return true;
  } else if((top=dynamic_cast<FlxTextObject *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting antialiasing attribute of '"+top->name()+"'");
    top->set_antialiasing(bp);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_graphics_object).name())+" can't have an antialiasing attribute");
    return false;
  }

} /* SetAntialiased */

/*****************************************************************************/

bool LoadTextFromFile(string *string_name,string *file_name){
  string cur_function="LoadTextFromFile";
  FlxTextFromFile *new_object;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Linking text file to variable '"+*string_name+"'");

  new_object=new FlxTextFromFile(*string_name,file_name);
  flx_add_scalar_source(new_object,file_name);
  flx_process_dependencies(new_object);
  return true;

} /* LoadTextFromFile */

/*****************************************************************************/

void flx_text_commands_init(void){
  
  flx_add_command("FontFace",SetFontFace);
  flx_add_command("FontSize",SetFontSize);
  flx_add_command("Justification",SetTextJustification);
  flx_add_command("TextBackgroundColor",SetTextBackgroundColor);
  flx_add_command("Antialiased",SetAntialiased,"true");
  flx_add_command("LoadTextFromFile",LoadTextFromFile);

} /* flx_text_commands_init */

/*****************************************************************************/

