/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.node.ExpressionNode;

public class CompiledFunction
implements Function {
    private String definition;
    private String name;
    private String[] parameters;
    private ExpressionNode expressionTree;

    public CompiledFunction(String string, String string2, String[] stringArray, ExpressionNode expressionNode) {
        this.definition = string;
        this.name = string2;
        this.parameters = stringArray;
        this.expressionTree = expressionNode;
        if (stringArray == null) {
            this.parameters = new String[0];
        }
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public boolean isValidParameterCount(int n) {
        return this.parameters.length == n;
    }

    public ExpressionNode getExpressionTree() {
        return this.expressionTree;
    }

    void setExpressionTree(ExpressionNode expressionNode) {
        this.expressionTree = expressionNode;
    }

    public double computeFunction(double[] dArray) {
        if (dArray == null && this.parameters.length > 0 || dArray != null && dArray.length < this.parameters.length) {
            throw new IllegalArgumentException("Too few parameters");
        }
        return this.expressionTree.computeExpression(dArray);
    }

    public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
        if (objectArray == null && this.parameters.length > 0 || objectArray != null && objectArray.length < this.parameters.length) {
            throw new IllegalArgumentException("Too few parameters");
        }
        return this.expressionTree.computeExpression(interpreter, objectArray);
    }
}

