/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.CompilationException;
import com.eteks.parser.CompiledExpression;
import com.eteks.parser.ExpressionParameter;
import com.eteks.parser.FunctionParser;
import com.eteks.parser.Parser;
import com.eteks.parser.Syntax;
import com.eteks.parser.node.ExpressionNode;
import com.eteks.parser.node.ExpressionParameterNode;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ExpressionParser
extends FunctionParser {
    private ExpressionParameter expressionParameter;

    public ExpressionParser(ExpressionParameter expressionParameter) {
        this.expressionParameter = expressionParameter;
    }

    public ExpressionParser(Syntax syntax, ExpressionParameter expressionParameter) {
        super(syntax);
        this.expressionParameter = expressionParameter;
    }

    public ExpressionParameter getExpressionParameter() {
        return this.expressionParameter;
    }

    public CompiledExpression compileExpression(String string) throws CompilationException {
        Syntax syntax = this.getSyntax();
        String string2 = syntax.getWhiteSpaceCharacters() != null ? syntax.getWhiteSpaceCharacters() : "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new CompilationException(8, 0);
        }
        Hashtable hashtable = new Hashtable(1);
        int n = 0;
        if (syntax.getAssignmentOperator() != null && syntax.getAssignmentOperator().length() > 0) {
            stringTokenizer = new StringTokenizer(string, string2);
            if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().startsWith(syntax.getAssignmentOperator())) {
                throw new CompilationException(8, 0);
            }
            n = string.indexOf(syntax.getAssignmentOperator());
        }
        if (n == string.length() - 1) {
            throw new CompilationException(8, n + 1);
        }
        ExpressionNode expressionNode = (ExpressionNode)this.parseExpression(string, n + (syntax.getAssignmentOperator() != null ? syntax.getAssignmentOperator().length() : 0), hashtable);
        return new CompiledExpression(string, hashtable, this.expressionParameter, expressionNode);
    }

    protected Parser.Lexical getLexical(String string, int n, Object object) throws CompilationException {
        try {
            return super.getLexical(string, n, object);
        }
        catch (CompilationException compilationException) {
            Object object2;
            if (compilationException.getErrorNumber() == 10 && compilationException.getExtractedString() != null && object instanceof Hashtable && this.expressionParameter != null && (object2 = this.expressionParameter.getParameterKey(compilationException.getExtractedString())) != null) {
                ((Hashtable)object).put(this.getSyntax().isCaseSensitive() ? compilationException.getExtractedString() : compilationException.getExtractedString().toUpperCase(), object2);
                return new Parser.Lexical(10, compilationException.getExtractedString(), object2);
            }
            throw compilationException;
        }
    }

    protected ExpressionNode getParameterNode(Parser.Lexical lexical, Object object) {
        if (object instanceof Hashtable) {
            return new ExpressionParameterNode(this.expressionParameter, lexical.getValue());
        }
        return super.getParameterNode(lexical, object);
    }
}

